﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
    public class ResetOutofstockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {

            Task.Factory.StartNew(() =>
            {
                Thread.Sleep(10 * 1000);
                try
                {
                    Console.WriteLine($"fba 1/2 月销量 开始  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    //daily.ResetFbaExtendSales(DateTime.Now);
                    Console.WriteLine($"fba 1/2 月销量 结束，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                catch (Exception ex)
                {
                    Console.WriteLine(" fba 1/2 月销量 异常 :"+ex.Message);
                    Console.WriteLine(" fba 1/2 月销量 异常: " +ex.StackTrace);
                }
              
            });




            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步调拨 采购临时数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        //dc_base_trans_temp_schedule_dao.SynchroTransTempScheduleData();
                        dc_base_trans_temp_schedule_dao.SynchroTransTempScheduleData(true);
                        Console.WriteLine($"结束 同步调拨 采购临时数据 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步调拨 采购临时数据:" + ex.Message);
                        Console.WriteLine("同步调拨 采购临时数据:"+ex.StackTrace);
                    }
                    Thread.Sleep(10 * 60 * 1000);
                }
                
            });  
             
            
            Task.Factory.StartNew(() =>
            {
                Thread.Sleep(10 * 60 * 1000);
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步生产订单数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_prod_order_dao.SynchroData();
                        Console.WriteLine($"结束 同步生产订单数据 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步生产订单数据:"+ex.Message);
                        Console.WriteLine("同步生产订单数据:"+ex.StackTrace);
                    }
                   
                }
                
            });
             Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    Thread.Sleep(10 * 60 * 1000);
                    try
                    {
                        Console.WriteLine($"开始 同步调拨单当前节点  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_transfer_extend_dao.SynchroLmsTransferOrder();
                        Console.WriteLine($"结束 同步调拨单当前节点 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步调拨单当前节点:"+ex.Message);
                        Console.WriteLine("同步调拨单当前节点:"+ex.StackTrace);
                    }
                    
                }
                
            });


            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_supplier_dao.SynchroBailunSupplier();
                        Console.WriteLine($"结束 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步供应商数据:"+ex.Message);
                        Console.WriteLine("同步供应商数据:"+ex.StackTrace);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            }); 
            
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        wip_stock_dao.Synchronization();
                        Console.WriteLine($"结束 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步半成品库存数据:"+ex.Message);
                        Console.WriteLine("同步半成品库存数据:"+ex.StackTrace);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        var now = DateTime.Now;
                        if (now.Hour>0 && now.Hour<=8)
                        {
                            Console.WriteLine("  刷新缺货明细数据 * (数据库忙时，暂停)");
                        }
                        else
                        {
                            Console.WriteLine($"开始刷新数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetOutofstock();
                            Console.WriteLine($"结束刷新数据任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                      
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新数据:"+ex.Message);
                        Console.WriteLine("开始刷新数据:"+ex.StackTrace);
                    }


                    Thread.Sleep(4 * 60 * 60 * 1000);
                }
            });
            

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        if (DateTime.Now.Hour >= 8)
                        {

                            Console.WriteLine($"开始刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetStockMonitorData();
                            Console.WriteLine($"结束刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新库存监控数据:"+ex.Message);
                        Console.WriteLine("开始刷新库存监控数据:"+ex.StackTrace);
                    }

                    Thread.Sleep(4 * 60 * 60 * 1000);
                }
            }); 
            
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report_cash_flow_dao.SynchroTransferCost();
                        Console.WriteLine($"结束同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始同步真实调拨费:"+ex.Message);
                        Console.WriteLine("开始同步真实调拨费:"+ex.StackTrace);
                    }

                    Thread.Sleep(60 * 60 * 1000);
                }
            });
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新最快到货的调拨单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_transfer_extend_dao.ResetData();
                        Console.WriteLine($"结束刷新最快到货的调拨单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新最快到货的调拨单数据:"+ex.Message);
                        Console.WriteLine("开始刷新最快到货的调拨单数据:"+ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 已经停止监控的周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_turnover.ResetHistory();
                        Console.WriteLine($"结束刷新 已经停止监控的周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("已经停止监控的周转数据:"+ex.Message);
                        Console.WriteLine("已经停止监控的周转数据:"+ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 商品报表库存字段增量刷新，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report.SynchroReportGoodsStockData();
                        report.SynchroReportGoodsOnTheWayData();
                        Console.WriteLine($"结束刷新 商品报表库存字段增量刷新，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("商品报表库存字段增量刷新:"+ex.Message);
                        Console.WriteLine("商品报表库存字段增量刷新"+ex.StackTrace);
                    }

                    Thread.Sleep(60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 增量刷新周转利润分析，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_turnover.SynchroCalculationProfitAnalysis();
                        Console.WriteLine($"结束刷新 增量刷新周转利润分析，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("增量刷新周转利润分析:"+ex.Message);
                        Console.WriteLine("增量刷新周转利润分析:"+ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 增量刷新母sku周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_mother_sku_dao.SynchroCalculationTurnOver();
                        Console.WriteLine($"结束刷新 增量刷新母sku周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("增量刷新母sku周转数据:" + ex.Message);
                        Console.WriteLine("增量刷新母sku周转数据:" + ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    Thread.Sleep(10 * 60 * 1000);
                    try
                    {
                        Console.WriteLine($"开始刷新 全链路在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_full_link_wait_order_dao.ResetDatas();
                        Console.WriteLine($"结束刷新 全链路在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("全链路在途:" + ex.Message);
                        Console.WriteLine("全链路在途:" + ex.StackTrace);
                    }

                   
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    
                    try
                    {
                        if (DateTime.Now.Hour > 8)
                        {
                            Console.WriteLine($"开始刷新 子母sku数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            dc_base_mother_sku_dao.GenerateData();
                            Console.WriteLine($"结束刷新 子母sku数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                        Thread.Sleep(10 * 60 * 1000);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("全链路在途:" + ex.Message);
                        Console.WriteLine("全链路在途:" + ex.StackTrace);
                    }

                   
                }
            });

           


            return Task.CompletedTask;
        }


        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
