﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using Bailun.ServiceFabric;
using Dapper;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using ShortagePush;
using System;
using System.Threading;
using System.Threading.Tasks;
using System.Linq;

namespace AutoGeneratePurchaseAdvise
{
    class Program
    {
        static async Task Main(string[] args)
        {
            Console.WriteLine("采购建议计算任务启动...");
            
            try
            {
                //PurchaseAdviseServices.Generate($"早上的全量周转 {DateTime.Now.ToString("HH: mm")}", DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 00:00:00")), is_clear_data: true);
                //PurchaseAdviseServices.Generate($"早上的全量周转 {DateTime.Now.ToString("HH: mm")}", DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 00:00:00")), is_clear_data: false);
                //PurchaseAdviseServices.Generate($"下午的补充周转 {DateTime.Now.ToString("HH: mm")}", DateTime.Parse(DateTime.Now.ToString("yyyy-MM-dd 12:00:00")));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
          
            var builder = new HostBuilder().ConfigureServices((hostContext, services) =>
                {
                    services.AddHostedService<GeneratePurchaseAdviseBackgroundService>();
                    services.AddHostedService<FirstBackgroundService>();
                });

            await builder.RunConsoleAsync();
        }
    }
}
