﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.Report
{
    public class dc_base_transfer_verify
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 调拨单号
        /// </summary>
        public string transfer_order_id { get; set; }

        /// <summary>
        /// 调拨目的仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 调拨目的仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 打包状态
        /// </summary>
        public string status { get; set; }

        /// <summary>
        /// 调拨系统创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 调拨数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// SKU标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 调拨系统主键
        /// </summary>
        public int transfer_key { get; set; }

        /// <summary>
        /// 是否被删除
        /// </summary>
        public int deleted { get; set; }

        /// <summary>
        /// 预计到达时间
        /// </summary>
        public DateTime? estimated_arrival_time { get; set; }

        /// <summary>
        /// 公司Id,0和1是百伦
        /// </summary>
        public int company_id { get; set; }

        /// <summary>
        /// 是否异常
        /// </summary>
        public int? isexception { get; set; }
    }

    public class dc_base_transfer_verify_dto: dc_base_transfer_verify
    {
        public DateTime? complete_time { get; set; }
        public decimal cost_first { get; set; }
        /// <summary>
        /// 渠道编码
        /// </summary>
        public string logisticscode { get; set; }
    }
    public class dc_base_transfer_delivery_dto : dc_base_transfer_delivery
    {
        public DateTime? complete_time { get; set; }
        public decimal cost_first { get; set; }
        /// <summary>
        /// 渠道编码
        /// </summary>
        public string logisticscode { get; set; }

    }

    public class transfer_box_dto
    {
        public DateTime creationtime { get; set; }
        public string logisticscode { get; set; }
        public int isdeleted { get; set; }
        public string box_id { get; set; }
        public string bailun_sku { get; set; }
        public string transfer_order_id { get; set; }
        public string warehouse_code { get; set; }
        public decimal cost_first { get; set; }

    }

    public class dc_base_transfer_delivery
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 调拨单号
        /// </summary>
        public string transfer_order_id { get; set; }

        /// <summary>
        /// 调拨目的仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 调拨目的仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 打包状态
        /// </summary>
        public string status { get; set; }

        /// <summary>
        /// 调拨系统创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 调拨数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// SKU标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 调拨系统主键
        /// </summary>
        public int transfer_key { get; set; }

        /// <summary>
        /// 是否被删除
        /// </summary>
        public int deleted { get; set; }

        /// <summary>
        /// 起始仓
        /// </summary>
        public string source_warehouse_code { get; set; }

        /// <summary>
        /// 公司Id,0和1是百伦
        /// </summary>
        public int company_id { get; set; }

        /// <summary>
        /// 是否异常
        /// </summary>
        public int? isexception { get; set; }
    }
    
}
