﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class ReportFinanceBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken) 
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;
           
            if (now.Hour == 0 && now.Minute == 01)
            {
                Console.WriteLine($"开始 财报财务付现数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationCashPayment(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报财务付现数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 02)
            {
                Console.WriteLine($"开始 财报出库退税数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationTax(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报出库退税数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 03)
            {
                Console.WriteLine($"开始 财报订单数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationOrder(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报订单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 04)
            {
                Console.WriteLine($"开始 财报订单-平台数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationOrderPlatfrom(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报订单-平台数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 05)
            {
                Console.WriteLine($"开始 财报退款数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationRefund(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 06)
            {
                Console.WriteLine($"开始 财报其他收入  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationOtherIncome(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报其他收入，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 06)
            {
                Console.WriteLine($"开始 财报筹资流入出  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationRaise(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报筹资流入出，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
             if (now.Hour == 0 && now.Minute == 06)
            {
                Console.WriteLine($"开始 财报应首付账款  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_report_finance_dao.CalculationAccounts(DateTime.Now.AddDays(-90));
                Console.WriteLine($"结束 财报应首付账款，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }


        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
