﻿using AutoTurnOver.Models;
using Bailun.ServiceFabric;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using AutoTurnOver.Utility;
using AutoTurnOver.DB;
using Dapper;
using System.Linq;
using System.Threading.Tasks;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 下载服务
    /// </summary>
    public class TaskDownloadServices
    {

        /// <summary>
        /// 开启下载任务
        /// </summary>
        public async Task<int> Download()
        {
            int count = 0;
            var dc_task_download_datas = MyMySqlConnection._connection_read_only.Query<dc_task_download>(" select * from dc_task_download where status=@status order by create_date desc ", new { status = (int)dc_task_download_status.待执行 }).ToList();
            foreach (var item in dc_task_download_datas)
            {
                // 查询当前待处理的任务
                try
                {
                    item.start_date = DateTime.Now;
                    MyMySqlConnection._connection.Update(item);
                    switch (item.task_name)
                    {
                        case "实时库存":
                           item.result_file_url = await DownloadStock(item.parameter, item);
                            break;   
                        case "周转表":
                           item.result_file_url = await DownloadAuto(item.parameter, item);
                            break; 
                        case "改在线记录":
                           item.result_file_url = await DownloadShortagePush(item.parameter, item);
                            break;
                        default: throw new Exception("无法识别的任务");
                    }
                    item.end_date = DateTime.Now;
                    item.status = (int)dc_task_download_status.执行完成;
                    count++;
                }
                catch (Exception ex)
                {
                    item.status = (int)dc_task_download_status.执行失败;
                    item.error_message = ex.Message;
                    item.error_stack_trace = ex.StackTrace;
                }
                MyMySqlConnection._connection.Update(item);

            }
            return count;
        }


        /// <summary>
        /// 下载改在线记录
        /// </summary>
        public async Task<string> DownloadShortagePush(string par_json, dc_task_download download_data)
        {

            export_sortage_push_search_dto search_data = par_json.ToObject<export_sortage_push_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().ExportShortagePush(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载库存
        /// </summary>
        public async Task<string> DownloadStock(string par_json, dc_task_download download_data)
        {
    
            dc_base_stock_search_dto search_data = par_json.ToObject<dc_base_stock_search_dto>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new DailyServices().Export(search_data);
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
        /// <summary>
        /// 下载周转表
        /// </summary>
        public async Task<string> DownloadAuto(string par_json, dc_task_download download_data)
        {
            Condition_AutoTurnOver search_data = par_json.ToObject<Condition_AutoTurnOver>();
            Console.WriteLine("DownloadStock - 开始生成文件");
            var memory = new SkuAutoTurnServices().Export(search_data,"","");
            Console.WriteLine("DownloadStock - 开始生成上传文件");
            var fileData = await AutoTurnOver.Utility.QiNiuCloudHelper.UploadSectioningAsync(memory);
            Console.WriteLine("DownloadStock - 上传完毕");
            return fileData;
        }
    }
}

