﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using System.Linq;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// 供应商节假日
    /// </summary>
    public class base_supplier_holiday_time_dao : connectionHelper
    {
        /// <summary>
        /// 同步所有节假日
        /// </summary>
        public static void SynchroData()
        {
            var conn = _connection;
            var datas = ApiUtility.getSupplierHolidayTimes();
            if (datas!=null)
            {
                foreach (var item in datas)
                {
                    var new_data = new base_supplier_holiday_time { 
                        source_sys_id = item.Id,
                        end_date = item.EndData,
                        reason = item.Reason,
                        start_date = item.StartData,
                        supplier_id = item.bailunSupplierId,
                        status = item.Status,
                        supplier_name = item.SupplierName,
                        gmt_update_time  =DateTime.Now
                    };
                    new_data.id = conn.QuerySingleOrDefault<int>(" select id from base_supplier_holiday_time where  source_sys_id=@source_sys_id ",new { source_sys_id  = new_data.source_sys_id });
                    if (new_data.id > 0)
                    {
                        conn.Update(new_data);
                    }
                    else
                    {
                        new_data.gmt_create_time = DateTime.Now;
                        conn.Insert(new_data);
                    }
                }
            }

            if(datas != null && datas.Count >= 1)
            {
                conn.Execute(" update base_supplier_holiday_time set status=0,gmt_update_time=now() where source_sys_id not in @source_sys_ids ", new { source_sys_ids = datas.Select(s=>s.Id).ToList() });
            }
            else
            {
                conn.Execute(" update base_supplier_holiday_time set status=0,gmt_update_time=now()  ");
            }
        }
    }
}
