﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Utility
{
    public static class DateHelper
    {
        /// <summary>
        /// 把秒转化成 天时分的格式
        /// </summary>
        /// <param name="s">秒</param>
        /// <returns></returns>
        public static string ToDateStr(this int s)
        {
            var t = new TimeSpan(0, 0, 0, s);
            string str = "";
            if (t.Days >= 1) { str += $"{t.Days}天"; }
            if (t.Hours >= 1) { str += $"{t.Hours}时"; }
            if (t.Minutes >= 1) { str += $"{t.Minutes}分"; }
            if (t.Seconds >= 1) { str += $"{t.Seconds}秒"; }
            return str;
        }

        public static string ToDateStr(this decimal s)
        {
            if (s <= 0) return "未设置";
            int zs = (int)Math.Floor(s);
            var t = new TimeSpan(0, 0, 0, zs);
            string str = "";
            if (t.Days >= 1) { str += $"{t.Days}天"; }
            if (t.Hours >= 1) { str += $"{t.Hours}时"; }
            if (t.Minutes >= 1) { str += $"{t.Minutes}分"; }
            if (t.Seconds >= 1) { str += $"{t.Seconds}秒"; }
            return str;
        }

        /// <summary>
        /// 获取该时间 的零点
        /// </summary>
        /// <param name="d"></param>
        /// <returns></returns>
        public static DateTime ToDayHome(this DateTime d)
        {
            return DateTime.Parse(d.ToString("yyyy-MM-dd 00:00:00"));
        }

        /// <summary>
        /// 获取该时间 的23点
        /// </summary>
        /// <param name="d"></param>
        /// <returns></returns>
        public static DateTime ToDayEnd(this DateTime d)
        {
            return DateTime.Parse(d.ToString("yyyy-MM-dd 23:59:59"));
        }

        /// <summary>
        /// 获取该时间 的零点
        /// </summary>
        /// <param name="d"></param>
        /// <returns></returns>
        public static DateTime ToDayDate(this DateTime d, int hour, int minute = 0)
        {
            return DateTime.Parse(d.ToString($"yyyy-MM-dd {hour}:{minute}:00"));
        }

        //// <summary>
        /// 取得某月的最后一天
        /// </summary>
        /// <param name="datetime">要取得月份最后一天的时间</param>
        /// <returns></returns>
        public static DateTime LastDayOfMonth(this DateTime datetime)
        {
            return datetime.AddDays(1 - datetime.Day).AddMonths(1).AddDays(-1);
        }

        public static DateTime GetMonthFirstDay(this DateTime datetime)
        {
            return DateTime.Parse(datetime.ToString("yyyy-MM-01 00:00:00"));
        }

        /// <summary>  
        /// 得到本周第一天(以星期一为第一天)  
        /// </summary>  
        /// <param name="datetime"></param>  
        /// <returns></returns>  
        public static DateTime GetWeekFirstDayMon(this DateTime datetime)
        {
            //星期一为第一天  
            int weeknow = Convert.ToInt32(datetime.DayOfWeek);

            //因为是以星期一为第一天，所以要判断weeknow等于0时，要向前推6天。  
            weeknow = (weeknow == 0 ? (7 - 1) : (weeknow - 1));
            int daydiff = (-1) * weeknow;

            //本周第一天  
            string FirstDay = datetime.AddDays(daydiff).ToString("yyyy-MM-dd");
            return Convert.ToDateTime(FirstDay);
        }
        /// <summary>  
        /// 得到本周最后一天(以星期天为最后一天)  
        /// </summary>  
        /// <param name="datetime"></param>  
        /// <returns></returns>  
        public static DateTime GetWeekLastDaySun(this DateTime datetime)
        {
            //星期天为最后一天  
            int weeknow = Convert.ToInt32(datetime.DayOfWeek);
            weeknow = (weeknow == 0 ? 7 : weeknow);
            int daydiff = (7 - weeknow);

            //本周最后一天  
            string LastDay = datetime.AddDays(daydiff).ToString("yyyy-MM-dd");
            return Convert.ToDateTime(LastDay);
        }

        /// <summary>
        /// 汉化 成小时为最小单位
        /// </summary>
        /// <param name=""></param>
        /// <returns></returns>
        public static string SinicizationByHours(this TimeSpan time_span)
        {
            var total_h = time_span.TotalHours;
            var val = "";
            var days = Math.Floor(total_h / 24);
            if (days >= 1)
            {
                val += $"{days}天";
            }
            var hours = Math.Round(total_h % 24);
            val += $"{hours}小时";
            return val;
        }

        /// <summary>
        /// 时间戳转时间
        /// </summary>
        /// <param name="time"></param>
        /// <returns></returns>
        public static DateTime StampToDateTime(this long? timeStamp_long)
        {
            if (timeStamp_long == null) return new DateTime(1991, 1, 1);
            var timeStamp = timeStamp_long.ToString();
            DateTime dtStart = TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1));
            long lTime = long.Parse(timeStamp + "0000");
            TimeSpan toNow = new TimeSpan(lTime);
            return dtStart.Add(toNow);
        }

        /// <summary>  
        /// 将DateTime时间格式转换为Unix时间戳格式  
        /// </summary>
        /// <param name="time">时间</param>  
        /// <returns>long</returns>  
        public static long GetUnixTime(this DateTime time)
        {
            System.DateTime startTime = TimeZone.CurrentTimeZone.ToLocalTime(new System.DateTime(1970, 1, 1, 0, 0, 0, 0));
            long t = (time.Ticks - startTime.Ticks) / 10000;   //除10000调整为13位      
            return t;
        }

        public static string Sinicization(this DayOfWeek week)
        {
            switch (week)
            {
                case DayOfWeek.Friday:
                    return "周五";
                case DayOfWeek.Monday:
                    return "周一";
                case DayOfWeek.Saturday:
                    return "周六";
                case DayOfWeek.Sunday:
                    return "周日";
                case DayOfWeek.Thursday:
                    return "周四";
                case DayOfWeek.Tuesday:
                    return "周二";
                case DayOfWeek.Wednesday:
                    return "周三";
                default:
                    return "";
                    break;
            }
        }

        public static List<DateTime> GetDayByWeek(this DayOfWeek week, DateTime bDate, DateTime eDate)
        {
            var datas = new List<DateTime>();
            var thisTime = bDate;
            while (thisTime <= eDate)
            {
                if (thisTime.DayOfWeek == week)
                {
                    datas.Add(thisTime);
                }
                thisTime = thisTime.AddDays(1);
            }
            return datas;
        }

        public static List<DateTime> GetDays(this DateTime bDate, DateTime eDate)
        {
            var datas = new List<DateTime>();
            var thisTime = bDate;
            while (thisTime <= eDate)
            {
                datas.Add(thisTime);
                thisTime = thisTime.AddDays(1);
            }
            return datas;
        }
        public static decimal? DecimalRoun(this decimal val, int num)
        {
            return Math.Round(val, num);
        }
        public static decimal? DecimalRoun(this decimal? val, int num)
        {
            if (val == null)
            {
                return null;
            }
            return Math.Round(val.Value, num);
        }
        /// <summary>
        /// 除法
        /// </summary>
        /// <param name="val1"></param>
        /// <param name="val2"></param>
        /// <returns></returns>
        public static decimal Division(this decimal val1, decimal val2)
        {
            if (val1 == 0 || val2 == 0)
            {
                return 0M;
            }
            else
            {
                return Math.Round(val1 / val2, 4);
            }
        }
        public static decimal Division(this int? val1, int? val2)
        {
            if (val1 == null || val2 == null)
            {
                return 0M;
            }
            else
            {
                return ((decimal)val1.Value).Division(val2.Value);
            }
        }
        public static decimal Division(this decimal? val1, decimal? val2)
        {
            if (val1 == null || val2 == null)
            {
                return 0M;
            }
            else
            {
                return val1.Value.Division(val2.Value);
            }
        }
        public static decimal Division(this decimal val1, decimal? val2)
        {
            if (val2 == null)
            {
                return 0M;
            }
            else
            {
                return val1.Division(val2.Value);
            }
        }

        /// <summary>
        /// 获取某个月份的 指点天数
        /// </summary>
        /// <param name="thime"></param>
        /// <param name="day"></param>
        /// <returns></returns>
        public static DateTime GetMonthToday(this DateTime time, int day)
        {
            var lsatTime = time.LastDayOfMonth();
            if (lsatTime.Day <= day)
            {
                return lsatTime;
            }
            else
            {
                return new DateTime(time.Year, time.Month, day);
            }
        }


        /// <summary>
        /// 四舍五入保留一位小数
        /// </summary>
        /// <param name="val"></param>
        /// <returns></returns>
        public static decimal Round1(this decimal val)
        {
            return Math.Round(val, 1);
        }

        /// <summary>
        /// 美国夏令时间转北京时间
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static DateTime AMESTimeToBeijinTime(this DateTime s)
        {
            return AMESTime.AMESTimeToBeijingTime(s);
        }
        public static DateTime BeijingTimeToAMESTime(this DateTime s)
        {
            return AMESTime.BeijingTimeToAMESTime(s);
        }


    }
}
