﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
    public class ResetOutofstockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            Task.Factory.StartNew(() =>
            {
                Console.WriteLine("开始刷新调拨订单数据");
                var now = DateTime.Now;
                //report_cash_flow_dao.CalculationTransferOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                //report.ResetCashFlowData();
                Console.WriteLine("结束调拨订单数据");
            });

          

            //Task.Factory.StartNew(() =>
            //{
            //    while (true)
            //    {
            //        try
            //        {

            //            Console.WriteLine($"开始 刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            //            var now = DateTime.Now;
            //            report_cash_flow_dao.CalculationPurchaseOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
            //            Console.WriteLine($"结束刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            //        }
            //        catch (Exception ex)
            //        {
            //            Console.WriteLine(ex.Message);
            //        }


            //        Thread.Sleep(240 * 60 * 60 * 1000);
            //    }
            //});

            //Task.Factory.StartNew(() =>
            //{
            //    while (true)
            //    {
            //        try
            //        {
            //            var now = DateTime.Now;
            //            Console.WriteLine($"开始 刷新订单 调拨  数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            //            report_cash_flow_dao.CalculationTransferOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
            //            Console.WriteLine($"结束 刷新订单 调拨  数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            //        }
            //        catch (Exception ex)
            //        {
            //            Console.WriteLine(ex.Message);
            //        }


            //        Thread.Sleep(240 * 60 * 60 * 1000);
            //    }
            //});


            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_supplier_dao.SynchroBailunSupplier();
                        Console.WriteLine($"结束 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            }); 
            
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        wip_stock_dao.Synchronization();
                        Console.WriteLine($"结束 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        var now = DateTime.Now;
                        if (now.Hour>2 && now.Hour<=8)
                        {
                            Console.WriteLine("  刷新缺货明细数据 * (数据库忙时，暂停)");
                        }
                        else
                        {
                            Console.WriteLine($"开始刷新缺货明细数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetOutofstock();
                            Console.WriteLine($"结束刷新缺货明细数据任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                      
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        if (DateTime.Now.Hour >= 8)
                        {
                            Console.WriteLine($"开始刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetStockMonitorData();
                            Console.WriteLine($"结束刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }

                    Thread.Sleep(5 * 60 * 1000);
                }
            }); 
            
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report_cash_flow_dao.SynchroTransferCost();
                        Console.WriteLine($"结束同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }

                    Thread.Sleep(60 * 60 * 1000);
                }
            });


            return Task.CompletedTask;
        }


        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
