﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    [NoLogin]
    public class ApiController : ControllerBase
    {

        [HttpGet("Test")]
        public ActionResult<RequestResultDto> Test()
        {
            return new RequestResultDto { success = true, data = 
                HttpHelper.Request("http://10.0.3.13/api/Logistics/ApiLogistics/GetPlatOfficialLine?PlatName=aliexpress&PlatSite=US&EndCountry=US&Skus=&WeightKg=0.015&Size=7,4,1&ElectrifiedType=1&SellMoney=1.6000&Currency=USD&OfficialLine=&postWay=&distribution=&logisticsId=0&EnterZip=&isIgnoreVolumeWeight=True&ruleStartPoint=1", RequestType.GET, timeout: 1000 * 60 * 60 * 24)
        };
        }

        [HttpPost("GetOutStockPage")]
        public ActionResult<RequestResultDto> GetOutStockPage([FromBody] dc_quantity_out_stock_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetOutStockPage(search) };
        } 
        
        [HttpPost("GetSkuSalesVolume")]
        public ActionResult<RequestResultDto> GetSkuSalesVolume([FromBody] api_sku_sales_volume_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetSkuSalesVolume(search) };
        } 
        
        [HttpPost("GetSkuTort")]
        public ActionResult<RequestResultDto> GetSkuTort([FromBody] api_sku_tort_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetSkuTort(search) };
        }

        /// <summary>
        /// 获取oms 订单数据
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        [HttpPost("GetOmsSkuFullPage")]
        public  async Task<ActionResult<RequestResultDto>> GetOmsSkuFullPage([FromBody] dc_base_oms_sku_full_search_dto search)
        {
            return new RequestResultDto { success = true, data = await ApiServices.GetOmsSkuFullPage(search) };
        }

        

        [HttpPost("Buys")]
        public JsonResult Buys([FromBody]AverageQueryDto queryDto)
        {
            try
            {
                return new JsonResult(new
                {
                    data = PurchaseAverageTargetServices.GetList(queryDto.sids, queryDto.skus),
                    success = true,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                });
            }
        }

        public class GetSkus_dto
        {
            public string skus { get; set; }
        }
        [HttpPost("GetSkus")]
        public JsonResult GetSkus([FromBody]GetSkus_dto queryDto)
        {
            try
            {
                return new JsonResult(new
                {
                    result = new DailyServices().GetSkus(queryDto.skus),
                    success = true,
                    statusCode=200
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                    statusCode = 500
                });
            }
        }

        [HttpPost("FirstOrderSkuAdd")]
        public JsonResult FirstOrderSkuAdd([FromBody]dc_auto_first_order_sku_input_dto inputData)
        {

            try
            {

                new FirstOrderService().Add(inputData);
                return new JsonResult(new
                {
                    success = true,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                });
            }
        }
    }
}