﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AutoTurnOver.Purchase.AverageTarget
{
    public class AverageTargetBackgrounService: BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        //Console.WriteLine($"开始 计算预测现金流，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report_cash_flow_forecast_dao.Calculation();
                        //Console.WriteLine($"结束 计算预测现金流，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("计算预测现金流"+ ex.Message);
                    }


                    Thread.Sleep(10 * 1000);
                }
            });

            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;
                // 判断是不是指定的时间
                if (now.Hour == 00 && now.Minute == 20)
                {
                    Console.WriteLine($"开始 计算退款sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    dc_auto_return_goods_config_dao.Calculation();
                    Console.WriteLine($"结束 计算退款sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                } // 判断是不是指定的时间
                if (now.Hour == 23 && now.Minute == 58)
                {
                    Console.WriteLine($"开始同步sku刊登状态，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    daily.SynchroPPSSkuStatus();
                    Console.WriteLine($"结束同步sku刊登状态，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 23 && now.Minute == 59)
                {
                    Console.WriteLine($"开始采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAverageTargetServices.Calculation();
                    Console.WriteLine($"结束采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
