﻿using AutoTurnOver.Models;
using AutoTurnOver.Models.dc_base_purchase;
using Dapper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AutoTurnOver.Utility;

namespace AutoTurnOver.DB
{

    /// <summary>
    ///  提货订单
    /// </summary>
    public class dc_auto_pick_up_goods_order_dao : connectionHelper
    {
        /// <summary>
        /// 生成提货订单
        /// </summary>
        public static void GenerateOrder(DateTime btime, DateTime etime)
        {
            var purchase_list = _connection.Query<dc_base_purchase_dto>(" select * from dc_base_purchase where create_time>=@btime and create_time<=@etime and buy_status!=-1 ", new
            {
                btime = btime.ToString("yyyy-MM-dd 00:00:00"),
                etime = etime.ToString("yyyy-MM-dd 23:59:59")
            }).ToList();

            foreach (var item in purchase_list.GroupBy(s => new { s.supplier_name, s.supplier_id }))
            {
                var dc_base_supplier_data = (_connection.QueryFirstOrDefault<dc_base_supplier>(" select * from dc_base_supplier where sup_value=@sup_value ", new { sup_value = item.Key.supplier_id }) ?? new dc_base_supplier());

                if (dc_base_supplier_data.isdaytakeinstore == 1)
                {
                    var count = 0;
                    foreach (var itemP in item.GroupBy(s => s.purchase_id))
                    {
                        count++;
                        // 生成编号
                        var order_no = $"{item.Key.supplier_name}-{DateTime.Now.ToString("MM-dd")}-提-{GetNumberStr(count)}";


                        var order_data = new dc_auto_pick_up_goods_order()
                        {
                            date = itemP.Max(s => s.create_time),
                            no = order_no,
                            order_1688_time = new DateTime(1991, 1, 1),
                            pay_time = item.Max(s => s.pay_time),
                            pick_up_goods_time = dc_base_supplier_data.laster_pockup_time ?? "",
                            purchase_id = itemP.Key,
                            warehouse_code = item.Max(v=>v.warehouse_code),
                            warehouse_name = item.Max(v=>v.warehouse_name)
                        };

                        // 查询是否已经存在

                        var old_count = _connection.QueryFirstOrDefault<int>(" select * from dc_auto_pick_up_goods_order where purchase_id=@purchase_id ", new { order_data.purchase_id });
                        if (old_count >= 1)
                        {
                            continue;
                        }

                        var new_main_id = _connection.Insert(order_data) ?? 0;

                        foreach (var itemSku in itemP.AsQueryable())
                        {
                            _connection.Insert(new dc_auto_pick_up_goods_order_sku
                            {
                                amount = (itemSku.price ?? 0) * itemSku.count,
                                quantity = itemSku.count,
                                bailun_sku = itemSku.bailun_sku,
                                main_id = new_main_id,
                                price = (itemSku.price ?? 0)
                            });
                        }
                    }
                }


            }


        }

        public static string GetNumberStr(int val)
        {
            var val_str = val.ToString();
            for (int i = val_str.Length; i < 3; i++)
            {
                val_str = ("0" + val_str);
            }
            return val_str;
        }

        public static List<dc_auto_pick_up_goods_order_view_dto> SkuPage(dc_auto_return_goods_sku_search_dto m, int offset, int limit, ref int total)
        {
            var list = new List<dc_auto_pick_up_goods_order_view_dto>();

            try
            {
                var sql = @"select 
t1.*,
( case when t5.`status`=0 or t5.`status` is null then '监控中' else '停止监控' end ) as 'monitor_status_str'
from dc_auto_return_goods_sku as t1 
left join dc_base_warehouse as t2 on t1.warehouse_code = t2.warehouse_code
left join dc_auto_config_sku_warehouse as t5 on t1.bailun_sku = t5.bailun_sku and t1.warehouse_code = t5.warehouse_code
where 1 = 1 ";
                DynamicParameters parameters = new DynamicParameters();
                if (m.monitor_status != null)
                {
                    if (m.monitor_status == 1)
                    {
                        sql += " and t5.`status`=1 ";
                    }
                    else if (m.monitor_status == 2)
                    {
                        sql += " and ( t5.`status`=0 or t5.`status` is null  ) ";
                    }
                }
                if (m.btime != null)
                {
                    sql += " and t1.create_date>=@btime ";
                    parameters.Add("btime", m.btime.Value.ToDayHome());
                }
                if (m.etime != null)
                {
                    sql += " and t1.create_date<=@etime ";
                    parameters.Add("etime", m.etime.Value.ToDayEnd());
                }
                if (!string.IsNullOrWhiteSpace(m.warehousetype))
                {
                    sql += " and t2.hq_type=@warehousetype";
                    parameters.Add("warehousetype", m.warehousetype);
                }
                if (!string.IsNullOrWhiteSpace(m.sku))
                {
                    sql += " and t1.bailun_sku=@bailun_sku";
                    parameters.Add("bailun_sku", m.sku);
                }
                if (m.warehousearea > 0)
                {
                    sql += " and t2.area_id=" + m.warehousearea;
                }
                if (m.warehouse_code != null)
                {
                    sql += $" and t1.warehouse_code=@warehouse_code ";
                    parameters.Add("warehouse_code", m.warehouse_code);
                }
                if (!string.IsNullOrWhiteSpace(m.supplier_name))
                {
                    sql += " and t1.suppliers_name =@suppliers_name ";
                    parameters.Add("suppliers_name", m.supplier_name);
                }
                if (m.status != null)
                {
                    sql += " and t1.status=" + m.status;
                }
                if (m.oms_out_status != null)
                {
                    sql += " and t1.oms_out_status=" + m.oms_out_status;
                }
                if (m.no_library_sys_push_status > 0)
                {
                    sql += " and t1.no_library_sys_push_status=" + m.no_library_sys_push_status;
                }

                total = _connection.ExecuteScalar<int>("select count(0) from (" + sql + ") tb1", parameters);

                var obj = _connection.Query<dc_auto_pick_up_goods_order_view_dto>(sql + " limit " + offset + "," + limit, parameters);

                return obj.AsList();

            }
            catch (Exception ex)
            {
                return list;
            }
        }
    }
}
