﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_average_warehouse
    {
        public int ID { get; set; }

        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 平均入库天数
        /// </summary>
        public int inbound_days { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime update_time { get; set; }

        /// <summary>
        /// 海运平均调拨天数
        /// </summary>
        public decimal transfer_type_1_days { get; set; }

        /// <summary>
        /// 空运平均调拨天数
        /// </summary>
        public decimal transfer_type_2_days { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 调拨头程天数
        /// </summary>
        public decimal transfer_delivery { get; set; }
        public int product_count { get; set; }
        public int order_count { get; set; }
        /// <summary>
        /// 产品数量 ( 海运 )
        /// </summary>
        public int product_count_2 { get; set; }
        /// <summary>
        /// 订单数量 ( 海运 )
        /// </summary>
        public int order_count_2 { get; set; }

        /// <summary>
        /// 产品数量 ( 空运 )
        /// </summary>
        public int product_count_3 { get; set; }
        public int product_count_1 { get; set; }
        /// <summary>
        /// 订单数量 ( 空运 )
        /// </summary>
        public int order_count_3 { get; set; }
        public int order_count_1 { get; set; }
        public decimal transfer_bale_delivery_ocean { get; set; }
        public decimal abroad_inbound_delivery_ocean { get; set; }
        public decimal transfer_delivery_ocean { get; set; }
        public decimal transfer_bale_delivery_empty { get; set; }
        public decimal abroad_inbound_delivery_empty { get; set; }
        public decimal transfer_delivery_empty { get; set; }
        public decimal transfer_sail_days_empty { get; set; }
        public decimal transfer_sail_days_ocean { get; set; }
        public decimal transfer_sail_days { get; set; }
    }

    public class dc_average_warehouse_dto : dc_average_warehouse
    {

        public decimal product_count_1_ratio
        {
            get
            {
                if (product_count > 0 && product_count_1 > 0)
                {
                    return Math.Round(((decimal)product_count_1) / product_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }
        public string product_count_1_ratio_str
        {
            get
            {
                return product_count_1_ratio.ToString("p");
            }
        }
        public decimal order_count_1_ratio
        {
            get
            {
                if (order_count > 0 && order_count_1 > 0)
                {
                    return Math.Round(((decimal)order_count_1) / order_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }

        public string order_count_1_ratio_str
        {
            get
            {
                return order_count_1_ratio.ToString("p");
            }
        }

        public decimal product_count_2_ratio
        {
            get
            {
                if (product_count > 0 && product_count_2 > 0)
                {
                    return Math.Round(((decimal)product_count_2) / product_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }
        public string product_count_2_ratio_str
        {
            get
            {
                return product_count_2_ratio.ToString("p");
            }
        }

        public decimal order_count_2_ratio
        {
            get
            {
                if (order_count > 0 && order_count_2 > 0)
                {
                    return Math.Round(((decimal)order_count_2) / order_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }

        public string order_count_2_ratio_str
        {
            get
            {
                return order_count_2_ratio.ToString("p");
            }
        }

        public decimal product_count_3_ratio
        {
            get
            {
                if (product_count > 0 && product_count_3 > 0)
                {
                    return Math.Round(((decimal)product_count_3) / product_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }

        public string product_count_3_ratio_str
        {
            get
            {
                return product_count_3_ratio.ToString("p");
            }
        }
        public decimal order_count_3_ratio
        {
            get
            {
                if (order_count > 0 && order_count_3 > 0)
                {
                    return Math.Round(((decimal)order_count_3) / order_count, 4);
                }
                else
                {
                    return 0M;
                }
            }
        }
        public string order_count_3_ratio_str
        {
            get
            {
                return order_count_3_ratio.ToString("p");
            }
        }
    }

}
