﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AutoTurnOver.DownloadService
{
  public  class DownloadService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            Task.Factory.StartNew(async () => 
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 下载任务  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        await new TaskDownloadServices().Download();
                        Console.WriteLine($"结束 下载任务 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Thread.Sleep(3 * 1000);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine(ex.StackTrace);
                    }
                }
            });

            Task.Factory.StartNew(() => 
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 转仓任务 执行  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_aims_transfer_warehouse_dao.TransferWarehouseTask();
                        Console.WriteLine($"结束 转仓任务 执行 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Thread.Sleep(60 * 1000);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine(ex.StackTrace);
                    }
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 转仓任务 监听完成状态  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_aims_transfer_warehouse_dao.MonitorCompleteStatus();
                        Console.WriteLine($"结束 转仓任务 监听完成状态 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                        Thread.Sleep(60 * 1000);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine(ex.StackTrace);
                    }
                }
            });

            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;

        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
