﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace AutoTurnOver.Purchase.AverageTarget
{
    /// <summary>
    /// 计算采购历史平均指标
    /// 最近5次平均交期
    /// 最近5次平均入库天数
    /// 最近5次平均（空运）调拨天数
    /// 最近5次平均（海运）调拨天数
    /// 最近5次平均采购价
    /// </summary>
    class Program
    {
        static async Task Main(string[] args)
        {
            Console.WriteLine("采购平均值计算任务启动...");
            try
            {
                //report.ResetTransExpectArrivaltime();
               PurchaseAverageTargetServices.CalculationTransfer("LM-EO-007", days: (360 * 3));
                //PurchaseAverageTargetServices.Calculation("942517901", days: (360 * 3));
                //ApiUtility.GetLmsTransportCountList(new Models.ApiDto.api_transport_count_order_transfer_query_dto { bailun_sku= "LM-EO-007", targetwareno= "MMDUSFBA" });

               //PurchaseAverageTargetServices.SynchroTransferTransportType();
            }
            catch (Exception ex)
            {
                throw;
            }

            var builder = new HostBuilder().ConfigureServices((hostContext, services) =>
            {
                services.AddHostedService<AverageTargetBackgrounService>();
            });

            await builder.RunConsoleAsync();
        }
    }
}
