﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 商品报表
    /// </summary>
    public class dc_report_goods_temp
    {
        public int id { get; set; }
        public  string product_code { get; set; }
        public  string product_title { get; set; }
        public  string product_type { get; set; }
        public  string warehouse_code { get; set; }
        public  string warehouse_name { get; set; }
        public  int stock { get; set; }
        public  DateTime? stock_update_time { get; set; }
        public  int on_the_way_quantity { get; set; }
        public  DateTime? on_the_way_quantity_update_time { get; set; }
        public  decimal unit_price { get; set; }
        public  decimal weight { get; set; }
        public  string buyer_name { get; set; }
        public  decimal sales_amount_usd { get; set; }
        public  int sales_yesterday { get; set; }
        public  decimal sales_yesterday_amount_usd { get; set; }
        public int sales_yesterday_7 { get; set; }
        public decimal sales_yesterday_amount_usd_7 { get; set; }
        public int sales_yesterday_30 { get; set; }
        public decimal sales_yesterday_amount_usd_30 { get; set; }
    }

    public class dc_report_goods : dc_report_goods_temp
    {

    }
    public class dc_report_goods_dto: dc_report_goods
    {
        public string warehouse_type { get; set; }
    }

    public class dc_report_goods_search_dto
    {
        [Description("商品编码")]
        public string product_code { get; set; }
        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description("仓库编码")]
        public string warehouse_code { get; set; }
    }


}
