﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DailyController : Controller
    {

        ///
        [HttpGet]
        public JsonResult PurchaseList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.List(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 调拨在途
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <param name="sku"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult TransferList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.TransferList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [UseAction]
        public JsonResult RealtimeList(int? monitor_status, int? searchType, string key_words, string warehousecode, string buyer_name, string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea, int? has_tort = null, string categoryIds = null,
           DateTime? start_date = null,DateTime? end_date =null,DateTime? f_start_date = null, DateTime? f_end_date = null,int? product_type = null)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.RealtimeList(monitor_status, searchType, key_words, warehousecode, supplier_name, offset, limit, ref total, warehousetype, warehousearea, order: order, sort: sort, has_tort: has_tort, categoryIds: categoryIds, buyer_name: buyer_name,start_date:start_date,end_date:end_date,f_start_date:f_start_date,f_end_date:f_end_date, product_type: product_type);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        }

        public JsonResult RealtimeListSumFooter(int? monitor_status, int? searchType, string key_words, string warehousecode, string buyer_name, string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea, int? has_tort = null, string categoryIds = null,
           DateTime? start_date = null, DateTime? end_date = null, DateTime? f_start_date = null, DateTime? f_end_date = null,int? product_type = null)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(monitor_status, searchType, key_words, warehousecode, supplier_name, offset, limit, ref total, warehousetype, warehousearea, true, has_tort: has_tort, categoryIds: categoryIds, buyer_name: buyer_name, start_date: start_date, end_date: end_date, f_start_date: f_start_date, f_end_date: f_end_date, product_type: product_type);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_stock_dto() : list[0]);
        }

        /// <summary>
        /// 缺货推送记录
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="bailun_sku"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public JsonResult ShortagePushList(string platform, string bailun_sku, int offset, int limit, DateTime? end_date, DateTime? start_date, string warehousecode, string warehousetype, int? warehousearea)
        {
            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.ShortagePushList(platform, bailun_sku, offset, limit, ref total, start_date,end_date,warehousecode, warehousetype, warehousearea);
                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }

        public FileResult ExportShortagePush(string platform, string bailun_sku, DateTime? end_date, DateTime? start_date, string warehousecode, string warehousetype, int? warehousearea)
        {
            var user = AutoUtility.GetUser();
            var memory = new DailyServices().ExportShortagePush(platform, bailun_sku, start_date, end_date, AutoUtility.GetUser(), warehousecode, warehousetype, warehousearea);
            return File(memory, "text/csv", $"{user.UserAccount}修改在线数量日志.csv");
        }

        /// <summary>
        /// 预计到货
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult EstimatedArrivalList(string sku, string warehousecode, int index)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.EstimatedArrivalList(sku, warehousecode, index);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        [UseAction]
        public FileResult ExportRealtime(int? monitor_status, int? searchType, string key_words, string warehousecode, string buyer_name, string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea, int? has_tort = null, string categoryIds = null,
           DateTime? start_date = null, DateTime? end_date = null, DateTime? f_start_date = null, DateTime? f_end_date = null)
        {
            var user = AutoUtility.GetUser();
            int total = 0;
            var memory = new DailyServices().Export(user, monitor_status, searchType, key_words, warehousecode, supplier_name, offset, limit, ref total, warehousetype, warehousearea, has_tort: has_tort, buyer_name: buyer_name, start_date: start_date, end_date: end_date, f_start_date: f_start_date, f_end_date: f_end_date);
            return File(memory, "text/csv", $"{user.UserAccount}实时库存.csv");
        }

        /// <summary>
        /// 缺货订单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public JsonResult OutOfStockOrderList(string sku, string warehousecode)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.OutOfStockOrderList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 库存监控
        /// </summary>
        /// <returns></returns>
        [UseAction]
        public JsonResult StockMonitorList(int? type, string bailun_sku, int offset, int limit, string order, string sort,
            DateTime? end_date, DateTime? start_date)
        {

            try
            {
                var services = new StockMonitorService();
                var page_data = services.GetPage(new dc_auto_stock_monitor_search_dto { type = type, bailun_sku = bailun_sku, page = offset + 1, rows = limit, sidx = sort, sord = order, start_date = start_date, end_date = end_date });

                return new JsonResult(new
                {
                    rows = page_data.Items,
                    total = page_data.TotalItems
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        }

        public JsonResult GetListingStatusPage(int offset, int limit, string order, string sort,
            DateTime? end_date, DateTime? start_date,string brand,int? has_tort,int? listing_status,int? warehousearea,int? source,string warehousetype,string warehouse_code)
        {
            try
            {
                var services = new StockMonitorService();
                var page_data = services.GetListingStatusPage(new listing_status_view_search_dto {warehouse_code = warehouse_code, warehousetype = warehousetype, source = source, warehousearea  = warehousearea, listing_status = listing_status,  brand = brand, has_tort = has_tort, page = offset + 1, rows = limit, sidx = sort, sord = order, start_date = start_date, end_date = end_date });

                return new JsonResult(new
                {
                    rows = page_data.Items,
                    total = page_data.TotalItems
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }

        public JsonResult GetShowField(string warehouse_code)
        {
            try
            {
                var services = new StockMonitorService();
                var datas = services.GetShowField(warehouse_code);

                return new JsonResult(datas);
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        [UseAction]
        public FileResult ExportStockMonitor(int? type, string bailun_sku,
            DateTime? end_date, DateTime? start_date)
        {
            var user = AutoUtility.GetUser();
            var memory = new StockMonitorService().Export(user, new dc_auto_stock_monitor_search_dto { type = type, bailun_sku = bailun_sku, page = 1, rows = int.MaxValue, start_date = start_date, end_date = end_date });
            return File(memory, "text/csv", $"{user.UserAccount}库存监控.csv");
        }


    }
}