﻿using AutoTurnOver.Models.ApiDto;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using static AutoTurnOver.Models.dc_base_stock_dto;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// sku自动周转
    /// </summary>
    public class dc_auto_turnover
    {
        public int id { get; set; }

        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }
        /// <summary>
        /// 调拨启航天数
        /// </summary>
        public decimal transfer_sail_days { get; set; }
        /// <summary>
        /// 销量预测公式
        /// </summary>
        public string sales_details_formula { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }


        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }

        /// <summary>
        /// 日均加权销量
        /// </summary>
        public decimal daily_weighted_sales { get; set; }


        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }

        /// <summary>
        /// 七天实际销量+预测销量
        /// </summary>
        public string sales_details { get; set; }

        /// <summary>
        /// 七天实际入库+预测入库
        /// </summary>
        public string inbound_details { get; set; }

        /// <summary>
        /// 七天实际库存+预测库存
        /// </summary>
        public string inventory_details { get; set; }

        /// <summary>
        /// 七天实际断货+预测断货
        /// </summary>
        public string short_supply_details { get; set; }

        /// <summary>
        /// 预测建议
        /// </summary>
        public string advised_details { get; set; }

        /// <summary>
        /// 默认供应商的平均预期天数
        /// </summary>
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        public string transfer_bale_delivery_source { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        public string abroad_inbound_delivery_source { get; set; }

        /// <summary>
        /// 补充销量
        /// </summary>
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 本次采购到货到货前
        /// </summary>
        public decimal turnover_sales { get; set; }
       
  

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }

        /// <summary>
        /// 销量预测算法
        /// </summary>
        public string sales_explain_details { get; set; }

        /// <summary>
        /// 调拨头程天数（用户配置）
        /// </summary>
        public int? transfer_config_delivery { get; set; }
        /// <summary>
        /// 调拨打包天数（用户配置）
        /// </summary>
        public int? transfer_bale_config_delivery { get; set; }
        /// <summary>
        /// 海外仓入库天数（用户配置）
        /// </summary>
        public int? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 初始建议数
        /// </summary>
        public int quantity_begin_advise { get; set; }
        public int original_quantity_init_advise { get; set; }
        public int is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        public int stock_up_days { get; set; }

        public int stock_up_days_final
        {
            get
            {
                if (stock_up_days >= 1)
                {
                    return stock_up_days - 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        public decimal history_sevenday_sales_ebay { get; set; }
        public decimal history_fourteenday_sales_ebay { get; set; }
        public decimal history_thirtyday_sales_ebay { get; set; }

        /// <summary>
        /// 默认发送的头程渠道 运输方式
        /// </summary>
        public string head_transport_type { get; set; }

        /// <summary>
        /// 默认发送的头程运输渠道 
        /// </summary>
        public string head_transport_logistics_code { get; set; }

        /// <summary>
        /// 采购平均下单天数
        /// </summary>
        public int? purchase_create_order_days { get; set; }

    }

    public class Condition_AutoTurnOver
    {
        [Description("sku标签")]
        public string sku_label { get; set; }

        [Description("待调拨数量（最小）")]
        public int? not_trans_count_min { get; set; }
        [Description("待调拨数量（最大）")]
        public int? not_trans_count_max { get; set; }

        [Description("sku")]
        public string bailun_sku { get; set; }

        [Description("采购员")]
        public string buyer_name { get; set; }

        [Description("供应商")]
        public string supplier_name { get; set; }

        [Description("是否侵权")]
        public int? has_tort { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description("仓库编码")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 是否缺货
        /// </summary>
        [Description("是否缺货")]
        public int? out_of_stock { get; set; }

        /// <summary>
        /// 是否冗余
        /// </summary>
        [Description("是否冗余")]
        public int? redundancy { get; set; }

        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }

        /// <summary>
        /// 是否有配置缺失
        /// </summary>
        [Description("是否有配置缺失")]
        public bool? hasDefectConfig { get; set; }

        /// <summary>
        /// 搜索关键词
        /// </summary>
        [Description("搜索关键词")]
        public string key_words { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        [Description("商品编码")]
        public int? searchType { get; set; }

        /// <summary>
        /// 是否建议下单
        /// </summary>
        [Description("是否建议下单")]
        public bool? hasAadvise { get; set; }

        /// <summary>
        /// 监控状态 
        /// 1= 停止监控
        /// 0 = 开启监控
        /// </summary>
        [Description("监控状态")]
        public int? monitor_status { get; set; }

        [Description("回货监控状态")]
        public int? returngoodspush_state { get; set; }

        /// <summary>
        ///百伦分类
        /// </summary>
        [Description("百伦分类")]
        public string categoryIds { get; set; }

        public List<bailun_category_new_dto> categoryModels { get; set; }

        [Description("实际库存（最小）")]
        public int? quantity_inventory_min { get; set; }

        [Description("实际库存（最大）")]
        public int? quantity_inventory_max { get; set; }

        [Description("缺货数量（最小）")]
        public int? quantity_out_stock_min { get; set; }

        [Description("缺货数量（最大）")]
        public int? quantity_out_stock_max { get; set; }

        [Description("昨日销量（最小）")]
        public int? oneday_sales_min { get; set; }

        [Description("昨日销量（最大）")]
        public int? oneday_sales_max { get; set; }

        [Description("日均类型")]
        public int? avg_type { get; set; }

        [Description("日均（最小）")]
        public int? avg_sales_min { get; set; }

        [Description("日均（最大）")]
        public int? avg_sales_max { get; set; }

        [Description("产品类型")]
        public string product_type { get; set; }
    }

    public class dc_auto_turnover_Extend : dc_auto_turnover
    {
        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }
    }

    public class dc_auto_turnover_list_dto
    {
        /// <summary>
        /// 备货数量
        /// </summary>
        public decimal? stock_up_sales { get; set; }
        /// <summary>
        /// 首次出单时间
        /// </summary>
        public DateTime? first_order_date { get; set; }


        /// <summary>
        /// 首次出单的订单
        /// </summary>
        public string first_order_bailun_order_id { get; set; }
        public string product_type_desc { get; set; }
        /// <summary>
        /// 日均出单次数
        /// </summary>
        public decimal? orders_avg { get; set; }
        /// <summary>
        /// 调拨单在途
        /// </summary>
        public int quantity_transfer_order { get; set; }
        public string db_warehouse_name { get; set; }

        /// <summary>
        /// 调拨单采购临时数据
        /// </summary>
        public int quantity_transfer_temp_schedule { get; set; }

        /// <summary>
        /// 调拨在途，暂存
        /// </summary>
        public int quantity_transfer_temporary_storage { get; set; }
        /// <summary>
        /// 待调拨数量
        /// </summary>
        public int not_trans_count { get; set; }
        public string area_name { get; set; }
        public string warehouse_type { get; set; }
        public string head_transport_type { get; set; }
        public string head_transport_logistics_code { get; set; }
        /// <summary>
        /// 销量预测规则
        /// </summary>
        public string dc_auto_sales_forecast_title { get; set; }
        public int quantity_land_purchase { get; set; }
        public DateTime? first_inbound_date { get; set; }
        public int quantity_ocean_purchase { get; set; }
        public int quantity_air_purchase { get; set; }
        public int quantity_railway_purchase { get; set; } 
        public int quantity_land_transfer { get; set; }
        public int quantity_ocean_transfer { get; set; }
        public int quantity_air_transfer { get; set; }
        public int quantity_railway_transfer { get; set; }


        public int returngoodspush_state { get; set; }
        public string category_simple_name { get; set; }
        public string brand { get; set; }
        public int id { get; set; }
        public string sales_details { get; set; }
        public int? sku_status { get; set; }
        public string sku_status_str
        {
            get
            {
                if (sku_status == null) return "";
                return ((sku_status_enum)sku_status).ToString();
            }
        }

        /// <summary>
        /// 动态备货规则组
        /// </summary>
        public string group_name { get; set; }
        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }


        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        //public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }
        public string transfer_delivery_source { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }


        /// <summary>
        /// 默认供应商的平均预期天数
        /// </summary>
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 补充销量
        /// </summary>
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 本次采购到货到货前
        /// </summary>
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }


        /// <summary>
        /// 调拨头程天数（用户配置）
        /// </summary>
        public int? transfer_config_delivery { get; set; }
        /// <summary>
        /// 调拨打包天数（用户配置）
        /// </summary>
        public int? transfer_bale_config_delivery { get; set; }
        /// <summary>
        /// 海外仓入库天数（用户配置）
        /// </summary>
        public int? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 初始建议数
        /// </summary>
        public int quantity_begin_advise { get; set; }
        public int original_quantity_init_advise { get; set; }
        public int is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        public int stock_up_days { get; set; }

        public int stock_up_days_final
        {
            get
            {
                if (stock_up_days >= 1)
                {
                    return stock_up_days - 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        public decimal history_sevenday_sales_ebay { get; set; }
        public decimal history_fourteenday_sales_ebay { get; set; }
        public decimal history_thirtyday_sales_ebay { get; set; }
        public decimal history_sevenday_sales_amazon { get; set; }
        public decimal history_fourteenday_sales_amazon { get; set; }
        public decimal history_thirtyday_sales_amazon { get; set; }

        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }

        /// <summary>
        /// 停止监控的时间
        /// </summary>
        public DateTime? stop_monitor_create { get; set; }

        public decimal history_sevenday_sales_aliexpress { get; set; }
        public decimal history_fourteenday_sales_aliexpress { get; set; }
        public decimal history_thirtyday_sales_aliexpress { get; set; }

        public string sku_label { get; set; }
    }
}
