﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ConfigController : Controller
    {
        #region 安全库存规则

        /// <summary>
        /// 获取安全库存规则设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult InventoryList(int limit, int offset, string order, string sort, string sku, string warehousecode, string warehousetype, int? warehousearea, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.InventoryList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存安全库存规则设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveInventory([FromBody]dc_auto_config_safe_inventory m)
        {
            var result = new Services.ConfigServices().SaveInventory(m,"");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetInventoryById(int id)
        {
            var m = new Services.ConfigServices().GetInventoryById(id);

            return new JsonResult(m);
        }

        #endregion

        #region 销量上限规则

        /// <summary>
        /// 获取销量上限设置列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult SalesUpperLimitList(int limit, int offset, string order, string sort, string sku, string warehousecode, string warehousetype, int? warehousearea, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.SalesUpperLimitList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存安全库存规则设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveSalesUpperLimit([FromBody]dc_auto_config_sales_upper_limit m)
        {
            var result = new Services.ConfigServices().SaveSalesUpperLimit(m, "");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetSalesUpperLimitById(int id)
        {
            var m = new Services.ConfigServices().GetSalesUpperLimitById(id);

            return new JsonResult(m);
        }

        #endregion

        #region 供应链长度规则

        /// <summary>
        /// 获取供应链长度列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ConfigDeliveryList(int limit, int offset, string order, string sort, string sku, string warehousecode, string warehousetype, int? warehousearea, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.ConfigDeliveryList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存供应链长度规则设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveConfigDelivery([FromBody]dc_auto_config_delivery m)
        {
            var result = new Services.ConfigServices().SaveConfigDelivery(m, "");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取供应链长度规则设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetConfigDeliveryById(int id)
        {
            var m = new Services.ConfigServices().GetConfigDeliveryById(id);

            return new JsonResult(m);
        }

        #endregion

        #region 备货天数

        /// <summary>
        /// 获取备货天数列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult StockUpList(int limit, int offset, string order, string sort, string sku, string warehousecode, string warehousetype, int? warehousearea, bool? IsEffective = null)
        {
            var m = new Condition_ConfigPromotion
            {
                sku = sku,
                warehousecode = warehousecode,
                IsEffective = IsEffective,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.StockUpList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存备货天数设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveStockUp([FromBody]dc_auto_config_stock_up_days m)
        {
            var result = new Services.ConfigServices().SaveStockUp(m, "");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取备货天数详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetStockUpById(int id)
        {
            var m = new Services.ConfigServices().GetStockUpById(id);

            return new JsonResult(m);
        }

        #endregion

        /// <summary>
        /// 监控状态修改
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult MonitorStatus(string bailun_sku,string warehouse_code,int monitor_status)
        {
            var user = AutoUtility.GetUser();
            if (user == null) return null;
            var result = new Services.ConfigServices().MonitorStatus(bailun_sku, warehouse_code, monitor_status, user);
            return new JsonResult(result);
        }

        /// <summary>
        /// 批量修改
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult BatchMonitorStatus(string ids, int monitor_status)
        {
            var user = AutoUtility.GetUser();
            if (user == null) return null;
            var result = new Services.ConfigServices().BatchMonitorStatus(ids, monitor_status, user);
            return new JsonResult(result);
        }


        #region fba共享仓发货仓

        /// <summary>
        /// 获取备货天数列表
        /// </summary>
        /// <param name="limit">每页记录数</param>
        /// <param name="offset">偏移量</param>
        /// <param name="order">排序字段</param>
        /// <param name="sort">升序还是降序</param>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="IsEffective">是否有效数据</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult StockFbaList(int limit, int offset, string order, string sort, string bailun_sku,string platform_sku, string warehousecode, string warehousetype, int? warehousearea)
        {
            var m = new Condition_ConfigPromotion
            {
                platform_sku = platform_sku,
                bailun_sku = bailun_sku,
                warehousecode = warehousecode,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.StockFbaList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        public JsonResult StockFbaLoseList(int limit, int offset, string order, string sort, string platform_sku)
        {
            var m = new Condition_ConfigPromotion
            {
                platform_sku = platform_sku
            };

            var total = 0;
            var service = new Services.ConfigServices();
            var list = service.StockFbaLoseList(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 保存备货天数设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult SaveStockFba([FromBody]dc_base_stock_config_fba m)
        {
            try
            {
                var result = new Services.ConfigServices().SaveStockFba(m, "");
                return new JsonResult(result);
            }
            catch (Exception ex)
            {
                return new JsonResult(ex.Message);
            }
           
        }


        /// <summary>
        /// 获取备货天数详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetStockFbaById(int id)
        {
            var m = new Services.ConfigServices().GetStockFbaById(id);

            return new JsonResult(m);

        }

        #endregion
    }
}