﻿using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Dapper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// 子母sku配置
    /// </summary>
    public class dc_base_mother_sku_dao : connectionHelper
    {

        public static List<decimal> MergeList(List<List<decimal>> datas)
        {
            var r = new List<decimal>();
            for (int i = 0; i < datas.Max(s => s.Count); i++)
            {
                decimal val = 0;
                foreach (var item in datas)
                {
                    if (item.Count - 1 >= i)
                    {
                        val += item[i];
                    }
                }
                r.Add(val);
            }

            return r;
        }

        public static List<string> MergeStringList(List<List<string>> datas)
        {
            var r = new List<string>();
            for (int i = 0; i < datas.Max(s => s.Count); i++)
            {
                List<string> val = new List<string>();
                foreach (var item in datas)
                {
                    if (item.Count - 1 >= i)
                    {
                        val.AddRange(item[i].Split('*'));
                    }
                }
                r.Add(string.Join("*", val));
            }

            return r;
        }

        public class temp_turnover_dto
        {
            public int id { get; set; }
            public string bailun_sku { get; set; }
            public string area_name { get; set; }
            public string warehouse_codes { get; set; }
            public List<warehouse_data_dto> warehouse_datas
            {
                get
                {
                    List<warehouse_data_dto> datas = new List<warehouse_data_dto>();
                    datas.AddRange(warehouse_codes.Split(',').Select(s =>
                    {
                        var temp_datas = s.Split('_');
                        return new warehouse_data_dto()
                        {
                            warehouse_code = temp_datas[0],
                            daily_weighted_sales = decimal.Parse(temp_datas[1]),
                            id = int.Parse(temp_datas[2]),
                        };
                    }).ToList());
                    return datas;
                }
            }
            public class warehouse_data_dto
            {
                public decimal daily_weighted_sales { get; set; }
                public string warehouse_code { get; set; }
                public int id { get; set; }
            }

        }
    }
}
