﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Services;
using AutoTurnOver.Models;
using AutoTurnOver.Models.auto;
using AutoTurnOver.DB;
using Dapper;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderController : ControllerBase
    {
        #region 下单管理

        /// <summary>
        /// 下单记录分页
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult List(string sku,string warehousecode,int offset,int limit,string order,string sort, string warehousetype, int? warehousearea)
        {
            var m = new Condition_AutoOrder {
                sku = sku,
                warehousecode = warehousecode,
                warehousetype = warehousetype,
                warehousearea = warehousearea
            };

            var services = new AutoOrderServices();
            var total = 0;
            var list = services.List(m, offset, limit, ref total).Select(p=> new {
                createtime = p.createtime.ToString("yyyy-MM-dd HH:mm:ss"),
                p.bailun_sku,
                p.warehouse_name,
                type = Enum.GetName(typeof(EnumAutoOrderType),p.type),
                p.buycount,
                p.suppliername,
                arrivaltime = p.arrivaltime.ToString("yyyy-MM-dd"),
            });

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        #endregion

        #region 销量管理

        /// <summary>
        /// 获取Sku销量详情
        /// </summary>
        /// <param name="id">主键id</param>
        /// <returns></returns>
        public JsonResult GetSaleVolume(int id,string sku,string warehousecode)
        {
            var services = new Services.SaleVolumeServices();
            var result = services.GetByTurnOverId(id, sku, warehousecode);


            // 提前查询周系数公式 
            var dc_base_week_coefficient_datas = MyMySqlConnection._connection_read_only.Query<dc_base_week_coefficient>(" select * from dc_base_week_coefficient where bailun_sku_warehouse_code=@bailun_sku_warehouse_code ", new
            {
                bailun_sku_warehouse_code = $"{sku}{warehousecode}"
            });

            var now = DateTime.Now;
            result.forecast_today_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(0).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_oneday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(1).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twoday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(2).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_threeday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(3).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_fourthday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(4).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_fiveday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(5).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_sixday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(6).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_sevenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(7).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_eightday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(8).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_nineday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(9).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_tenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(10).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_elevenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(11).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twelveday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(12).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_thridteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(13).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_fourteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(14).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_fifteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(15).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_sixteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(16).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_seventeenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(17).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_eighteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(18).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_nineteenday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(19).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twentyday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(20).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_oneday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(21).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_twoday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(22).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_threeday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(23).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_fourthday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(24).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_fiveday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(25).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_sixday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(26).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_seveneday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(27).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_eightday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(28).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_twenty_nineday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(29).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;
            result.forecast_thirtyday_sales *= (dc_base_week_coefficient_datas.FirstOrDefault(s => s.week == (int)now.AddDays(30).DayOfWeek) ?? new dc_base_week_coefficient() { coefficient = 1 }).coefficient;

            var _service = new Services.SkuAutoTurnServices();
            var inventory = new dc_auto_inventory();

            if (result != null && result.bailun_sku!=null && result.warehouse_code!=null)
            {
                inventory = _service.GetAutoInventoryBySkuWH(result.bailun_sku, result.warehouse_code);
            }
            
            return new JsonResult(new {
                volume = result,
                inventory = inventory
            });
        }

        #endregion

    }
}