﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class StockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;

            if (now.Hour == 0 && now.Minute == 01)
            {
                Console.WriteLine($"开始 备份库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetDailyStockWarehouse();
                Console.WriteLine($"结束 备份库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.DayOfWeek == DayOfWeek.Monday)
            {
                if (now.Hour == 0 && now.Minute == 10)
                {
                    Console.WriteLine($"开始 备份上周库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.StockWeekBackUp();
                    Console.WriteLine($"结束 备份上周库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 0 && now.Minute == 11)
                {
                    Console.WriteLine($"开始 备份上周采购库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.PurchaseWeekBackUp();
                    Console.WriteLine($"结束 备份上周采购库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }

            if(now.Hour==8 && now.Minute == 1)
            {
                Console.WriteLine($"开始 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report.ResetInventory();
                Console.WriteLine($"结束 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if(now.Hour==02 && now.Minute == 1)
            {
                Console.WriteLine($"开始 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                dc_auto_pick_up_goods_order_dao.GenerateOrder(DateTime.Now.AddDays(-1), DateTime.Now);
                Console.WriteLine($"结束 刷新jit安全库存，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
