﻿using AutoTurnOver.Models.ApiDto;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// sku自动周转
    /// </summary>
    public class dc_auto_turnover
    {
        public int id { get; set; }

        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }


        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }

        /// <summary>
        /// 七天实际销量+预测销量
        /// </summary>
        public string sales_details { get; set; }

        /// <summary>
        /// 七天实际入库+预测入库
        /// </summary>
        public string inbound_details { get; set; }

        /// <summary>
        /// 七天实际库存+预测库存
        /// </summary>
        public string inventory_details { get; set; }

        /// <summary>
        /// 七天实际断货+预测断货
        /// </summary>
        public string short_supply_details { get; set; }

        /// <summary>
        /// 预测建议
        /// </summary>
        public string advised_details { get; set; }

        /// <summary>
        /// 默认供应商的平均预期天数
        /// </summary>
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 补充销量
        /// </summary>
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 本次采购到货到货前
        /// </summary>
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }

        /// <summary>
        /// 销量预测算法
        /// </summary>
        public string sales_explain_details { get; set; }

        /// <summary>
        /// 调拨头程天数（用户配置）
        /// </summary>
        public int? transfer_config_delivery { get; set; }
        /// <summary>
        /// 调拨打包天数（用户配置）
        /// </summary>
        public int? transfer_bale_config_delivery { get; set; }
        /// <summary>
        /// 海外仓入库天数（用户配置）
        /// </summary>
        public int? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 初始建议数
        /// </summary>
        public int quantity_begin_advise { get; set; }
        public int original_quantity_init_advise { get; set; }
        public int is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        public int stock_up_days { get; set; }

        public int stock_up_days_final
        {
            get
            {
                if (stock_up_days >= 1)
                {
                    return stock_up_days - 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        public decimal history_sevenday_sales_ebay { get; set; }
        public decimal history_fourteenday_sales_ebay { get; set; }
        public decimal history_thirtyday_sales_ebay { get; set; }

    }

    public class Condition_AutoTurnOver
    {

        public string bailun_sku { get; set; }

        public string buyer_name { get; set; }

        public string supplier_name { get; set; }
        public int? has_tort { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 是否缺货
        /// </summary>
        public int? out_of_stock { get; set; }

        /// <summary>
        /// 是否冗余
        /// </summary>
        public int? redundancy { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }

        /// <summary>
        /// 是否有配置缺失
        /// </summary>
        public bool? hasDefectConfig { get; set; }

        /// <summary>
        /// 搜索关键词
        /// </summary>
        public string key_words { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public int? searchType { get; set; }

        /// <summary>
        /// 是否建议下单
        /// </summary>
        public bool? hasAadvise { get; set; }

        /// <summary>
        /// 监控状态 
        /// 1= 停止监控
        /// 0 = 开启监控
        /// </summary>
        public int? monitor_status { get; set; }

        /// <summary>
        ///百伦分类
        /// </summary>
        public string categoryIds { get; set; }

        public List<CategoryDto> categoryModels { get; set; }
    }

    public class dc_auto_turnover_Extend : dc_auto_turnover
    {
        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }
    }

    public class dc_auto_turnover_list_dto
    {
        public int id { get; set; }

        /// <summary>
        /// 建议单单号
        /// </summary>
        public string purchase_advice_id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 建议采购数
        /// </summary>
        public int quantity_init_advise { get; set; }

        /// <summary>
        /// 最小订单数量
        /// </summary>
        public int quantity_minimum_order { get; set; }

        /// <summary>
        /// 跟MOQ对比后最终的的自动采购建议
        /// </summary>
        public int quantity_final_advise { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 活动促销数量
        /// </summary>
        public int quantity_promotion { get; set; }

        /// <summary>
        /// 实际库存数量
        /// </summary>
        public int quantity_inventory { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 周转天数
        /// </summary>
        public int turnover_days { get; set; }

        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }


        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 正常为0, 缺货为1
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string sku_title { get; set; }

        /// <summary>
        /// 记录时间
        /// </summary>
        public DateTime record_time { get; set; }

        /// <summary>
        /// 与dc_auto_config_promotion的id关联,以逗号分隔
        /// </summary>
        //public string promotions { get; set; }

        /// <summary>
        /// 供应商交期
        /// </summary>
        public int supplier_delivery { get; set; }

        /// <summary>
        /// 调拨交运时长
        /// </summary>
        public int transfer_delivery { get; set; }

        /// <summary>
        /// 质检入库时长
        /// </summary>
        public int inspection_delivery { get; set; }
        /// <summary>
        /// 未来7天日均
        /// </summary>

        public int forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 未来14天日均
        /// </summary>
        public int forecast_fourteenday_sales { get; set; }


        /// <summary>
        /// 默认供应商的平均预期天数
        /// </summary>
        public decimal average_overdue { get; set; }

        /// <summary>
        /// 调拨打包天数
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 补充销量
        /// </summary>
        public decimal supplementary_sales { get; set; }

        /// <summary>
        /// 本次采购到货到货前
        /// </summary>
        public decimal turnover_sales { get; set; }

        /// <summary>
        /// 周转期内总入库
        /// </summary>
        public decimal turnover_inbound { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }


        /// <summary>
        /// 调拨头程天数（用户配置）
        /// </summary>
        public int? transfer_config_delivery { get; set; }
        /// <summary>
        /// 调拨打包天数（用户配置）
        /// </summary>
        public int? transfer_bale_config_delivery { get; set; }
        /// <summary>
        /// 海外仓入库天数（用户配置）
        /// </summary>
        public int? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 初始建议数
        /// </summary>
        public int quantity_begin_advise { get; set; }
        public int original_quantity_init_advise { get; set; }
        public int is_modify_quantity_init_advise { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public int payment_before_delivery { get; set; }

        /// <summary>
        /// 备货天数
        /// </summary>
        public int stock_up_days { get; set; }

        public int stock_up_days_final
        {
            get
            {
                if (stock_up_days >= 1)
                {
                    return stock_up_days - 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        public decimal history_sevenday_sales_ebay { get; set; }
        public decimal history_fourteenday_sales_ebay { get; set; }
        public decimal history_thirtyday_sales_ebay { get; set; }

        /// <summary>
        ///昨日销量
        /// </summary>
        public int oneday_sales { get; set; }

        /// <summary>
        /// 预测明日销量
        /// </summary>
        public int forecast_oneday_sales2 { get; set; }

        /// <summary>
        /// 商品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 是否停止监控
        /// </summary>
        public int monitor_status { get; set; }

        public string supplier_name { get; set; }


        public string buyer_name { get; set; }

        /// <summary>
        /// 交期异常
        /// </summary>
        public int? delivery_days_error { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        /// <summary>
        /// 实时库存
        /// </summary>
        public decimal? usable_stock { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal? shipped_stock { get; set; }

        /// <summary>
        /// 供应链链接
        /// </summary>
        public string suppliers_link { get; set; }

        public DateTime? develop_time { get; set; }

        public string has_tort { get; set; }
    }
}
