﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DailyController : Controller
    {

        ///
        [HttpGet]
        public JsonResult PurchaseList(string warehousecode, string sku)
        {
           
            var service = new Services.DailyServices();
            var list = service.List(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 调拨在途
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <param name="sku"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult TransferList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.TransferList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        

        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult RealtimeList(string sku,string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn,string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea,int? has_tort = null)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, bailun_sku, warehousecode,product_inner_code, sku_title_cn, supplier_name, offset, limit, ref total,warehousetype,warehousearea,order: order, sort: sort, has_tort : has_tort);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        public JsonResult RealtimeListSumFooter(string sku, string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn,string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea,int? has_tort = null)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, bailun_sku, warehousecode, product_inner_code, sku_title_cn, supplier_name, offset, limit, ref total, warehousetype, warehousearea,true, has_tort: has_tort);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_stock_dto() : list[0]);
        }

        

        /// <summary>
        /// 预计到货
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult EstimatedArrivalList(string sku, string warehousecode, int index)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.EstimatedArrivalList(sku, warehousecode, index);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public FileResult ExportRealtime(string sku,string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn,string supplier_name, string warehousetype, int? warehousearea,int? has_tort = null)
        {
            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, bailun_sku, warehousecode, product_inner_code, sku_title_cn, supplier_name, 0, int.MaxValue, ref total,warehousetype,warehousearea, has_tort: has_tort);

            DataTable table = new DataTable();
            string[] cols = new string[] { "Sku", "采购名称", "中文名", "英文名称","内部编码", "仓库编码", "仓库名称", "货主编码","实时采购在途","实时调拨在途"
                ,"订货数量","运输在途","中转仓库存","冻结库存","供应商库存","预售库存","不良品库存","在途库存","收货待检"
                 ,"待上架","可配库存","销售可用库存(聚合)","销售可用库存(私有)","销售可用库存(共享)","在仓库存(共享)","在仓库存(私有)","在仓库存(聚合)","仓库占用(共享)"
                  ,"仓库占用(私有)","仓库占用(聚合)","活动占用","单占用(私有)","订单占用(共享)","订单占用(聚合)","环球更新时间","供应商","采购员","重量","单价","已发货库存","实时缺货","是否侵权"
            };
            foreach (var item in cols)
            {
                table.Columns.Add(item);
            }

            foreach (var itemData in list)
            {
                DataRow row = table.NewRow();

                row["Sku"] = itemData.bailun_sku;
                row["采购名称"] = itemData.buyer_name;
                row["中文名"] = itemData.sku_title_cn;
                row["英文名称"] = itemData.sku_title_en;
                row["内部编码"] = itemData.product_inner_code;
                row["仓库编码"] = itemData.warehouse_code;
                row["仓库名称"] = itemData.warehouse_name;
                row["货主编码"] = itemData.owner_code;
                row["订货数量"] = itemData.quantity_reservation;
                row["运输在途"] = itemData.quantity_transport;
                row["中转仓库存"] = itemData.quantity_transfer;
                row["冻结库存"] = itemData.quantity_freeze;
                row["供应商库存"] = itemData.quantity_supplier;
                row["预售库存"] = itemData.quantity_presell;
                row["不良品库存"] = itemData.quantity_defective;
                row["在途库存"] = itemData.quantity_transit;
                row["收货待检"] = itemData.wait_check;
                row["待上架"] = itemData.wait_putaway;
                row["可配库存"] = itemData.usable_stock;
                row["销售可用库存(聚合)"] = itemData.usable_sales;
                row["销售可用库存(私有)"] = itemData.usable_sales_private;
                row["销售可用库存(共享)"] = itemData.usable_sales_share;
                row["在仓库存(共享)"] = itemData.in_warehouse_share;
                row["在仓库存(私有)"] = itemData.in_warehouse_private;
                row["在仓库存(聚合)"] = itemData.in_warehouse;
                row["仓库占用(共享)"] = itemData.occupy_stock_share;
                row["仓库占用(私有)"] = itemData.occupy_stock_private;
                row["仓库占用(聚合)"] = itemData.occupy_stock;
                row["活动占用"] = itemData.occupy_activity;
                row["单占用(私有)"] = itemData.occupy_order_private;
                row["订单占用(共享)"] = itemData.occupy_order;
                row["订单占用(聚合)"] = itemData.occupy_order_share;
                row["环球更新时间"] = itemData.update_time;

                row["实时采购在途"] = itemData.realtime_quantity_purchase;
                row["实时调拨在途"] = itemData.realtime_quantity_transfer;
                row["供应商"] = itemData.suppliers_name;
                row["采购员"] = itemData.buyer_name;
                row["重量"] = itemData.weight;
                row["单价"] = itemData.unit_price;
                row["已发货库存"] = itemData.shipped_stock;
                row["实时缺货"] = itemData.quantity_out_stock;
                row["是否侵权"] = itemData.has_tort;
                
                table.Rows.Add(row);
            }

            var fileName = AppContext.BaseDirectory+ @"Result\RealtimeStock\实时库存.csv";
           
            DataTableHelper.SaveCSV(table, fileName);

            var memory = new MemoryStream();
            using (var stream = new FileStream(fileName, FileMode.Open))
            {
                stream.CopyTo(memory);
            }
            memory.Position = 0;
            return File(memory, "text/csv", "实时库存.csv");
        }

        /// <summary>
        /// 缺货订单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public JsonResult OutOfStockOrderList(string sku, string warehousecode)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.OutOfStockOrderList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }
    }
}