﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_base_stock
    {
        public int id { get; set; }

        public string bailun_sku { get; set; }

        public string warehouse_code { get; set; }

        /// <summary>
        /// 货主编码
        /// </summary>
        public string owner_code { get; set; }

        /// <summary>
        /// 订货数量
        /// </summary>
        public int quantity_reservation { get; set; }

        /// <summary>
        /// 运输在途
        /// </summary>
        public int quantity_transport { get; set; }

        /// <summary>
        /// 中转仓库存
        /// </summary>
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 冻结库存
        /// </summary>
        public int quantity_freeze { get; set; }

        /// <summary>
        /// 供应商库存
        /// </summary>
        public int quantity_supplier { get; set; }

        /// <summary>
        /// 预售库存
        /// </summary>
        public int quantity_presell { get; set; }

        /// <summary>
        /// 不良品库存
        /// </summary>
        public int quantity_defective { get; set; }

        /// <summary>
        /// 在途库存
        /// </summary>
        public int quantity_transit { get; set; }

        /// <summary>
        /// 收货待检
        /// </summary>
        public int wait_check { get; set; }

        /// <summary>
        /// 待上架
        /// </summary>
        public int wait_putaway { get; set; }

        /// <summary>
        /// 可配库存
        /// </summary>
        public int usable_stock { get; set; }

        /// <summary>
        /// 销售可用库存(聚合)
        /// </summary>
        public int usable_sales { get; set; }

        /// <summary>
        /// 销售可用库存(私有)
        /// </summary>
        public int usable_sales_private { get; set; }

        /// <summary>
        /// 销售可用库存(共享)
        /// </summary>
        public int usable_sales_share { get; set; }

        /// <summary>
        /// 在仓库存(共享)
        /// </summary>
        public int in_warehouse_share { get; set; }

        /// <summary>
        /// 在仓库存(私有)
        /// </summary>
        public int in_warehouse_private { get; set; }

        /// <summary>
        /// 在仓库存(聚合)
        /// </summary>
        public int in_warehouse { get; set; }

        /// <summary>
        /// 仓库占用(共享)
        /// </summary>
        public int occupy_stock_share { get; set; }

        /// <summary>
        /// 仓库占用(私有)
        /// </summary>
        public int occupy_stock_private { get; set; }

        /// <summary>
        /// 仓库占用(聚合)
        /// </summary>
        public int occupy_stock { get; set; }

        /// <summary>
        /// 活动占用
        /// </summary>
        public int occupy_activity { get; set; }

        /// <summary>
        /// 订单占用(私有)
        /// </summary>
        public int occupy_order_private { get; set; }

        /// <summary>
        /// 订单占用(共享)
        /// </summary>
        public int occupy_order_share { get; set; }

        /// <summary>
        /// 订单占用(聚合)
        /// </summary>
        public int occupy_order { get; set; }

        /// <summary>
        /// 环球更新时间
        /// </summary>
        public DateTime update_time { get; set; }

        /// <summary>
        /// 环球创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 已发货数
        /// </summary>
        public decimal shipped_stock { get; set; }
    }

    public class dc_base_stock_dto : dc_base_stock
    {
        public string warehouse_name { get; set; }
        public string sku_name { get; set; }
        /// <summary>
        /// 内部系统采购在途
        /// </summary>
        public int? purchase_daily_quantity { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 产品中文名
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 产品英文名
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 产品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 实时采购在途
        /// </summary>
        public int realtime_quantity_purchase { get; set; }

        /// <summary>
        /// 实时调拨在途
        /// </summary>
        public int realtime_quantity_transfer { get; set; }

        public string suppliers_name { get; set; }

        public decimal? quantity_out_stock { get; set; }

        public DateTime? gmt_out_stock_modified { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        public string has_tort { get; set; }
    }
}
