﻿using AutoTurnOver.DB;
using AutoTurnOver.Models.ApiDto.WeeklyStatistics;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Linq;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 普货周数据统计
    /// </summary>
    public class WeeklyStatisticsServices
    {
        /// <summary>
        /// Aims周负利润订单分页数据
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<week_negative_profit_details_page_output_dto> GetWeekNegativeProfitDetailsPageList(week_negative_profit_details_page_input_dto m, int offset, int limit, ref int total)
        {
            return dc_auto_week_negative_profit_details_dao.GetWeekNegativeProfitDetailsPageList(m, offset, limit, ref total);
        }

        /// <summary>
        /// 分页查询aims-本周新增冗余明细
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<week_redundancy_details_page_output_dto> GetWeekRedundancyDetailsPageList(week_redundancy_details_page_input_dto m, int offset, int limit, ref int total)
        {
            return dc_auto_week_redundancy_details_dao.GetWeekRedundancyDetailsPageList(m, offset, limit, ref total);
        }

        /// <summary>
        /// 分页aims普货周缺货数据明细
        /// </summary>
        /// <param name="m"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<week_shortage_details_page_output_dto> GetWeekShortagePageList(week_shortage_details_page_input_dto m, int offset, int limit, ref int total)
        {
            return dc_auto_week_shortage_dao.GetWeekShortagePageList(m, offset, limit, ref total);
        }

        /// <summary>
        /// 定时执行周负利润订单
        /// </summary>
        public void TimingWeekNegativeProfitTask()
        {
            int limit = 20;
            int total = 0;
            DateTime startTime = DateHelper.GetWeekFirstDayMon(DateTime.Now);
            DateTime endtime = DateHelper.GetWeekLastDaySun(DateTime.Now).AddDays(1).AddMilliseconds(-1);
            for (int i = 1; i < 10000; i++)
            {
                int offset = (i - 1) * limit;
                var dataList = dc_auto_week_negative_profit_details_dao.GetGmvPageList(startTime, endtime, offset, limit, ref total);
                if (dataList.Count <= 0) break;
                foreach (var item in dataList)
                {
                    var model = new Models.dc_auto_week_negative_profit_details
                    {
                        bailun_sku = item.bailun_sku,
                        weekly_sales = Convert.ToInt32(item.bailun_sku_quantity_ordered_7),
                        weekly_gmv = item.amount_sales_usd_7,
                        weekly_cost = item.weekly_cost_of_sales,
                        weekly_refunds_num = item.weekly_refunds_num,
                        weekly_refund_amount = item.weekly_refund_amount,
                        amount_of_profit = item.profit_total,
                        profit_margin = item.profit_rate,
                        refund_rate = item.weekly_refund_amount>0? Math.Round(item.weekly_refund_amount / item.amount_sales_usd_7,2):0,
                        create_date_time = DateTime.Now,
                        start_date = DateHelper.GetWeekFirstDayMon(DateTime.Now.AddDays(-1)),
                        end_date = DateHelper.GetWeekLastDaySun(DateTime.Now.AddDays(-1))
                    };
                    dc_auto_week_negative_profit_details_dao.Insert(model);
                    Console.WriteLine($"写入负利润数据：{i}---{item.bailun_sku}");
                }
            }
        }

        /// <summary>
        /// 定时执行冗余数据
        /// </summary>
        public void TimingWeekRedundancyTask()
        {
            int limit = 20;
            int total = 0;
            DateTime startTime = DateHelper.GetWeekFirstDayMon(DateTime.Now.AddDays(-1));
            DateTime endtime = DateHelper.GetWeekLastDaySun(DateTime.Now.AddDays(-1)).AddDays(1).AddMilliseconds(-1);
            for (int i = 1; i < 10000; i++)
            {
                int offset = (i - 1) * limit;
                var dataList = dc_auto_week_redundancy_details_dao.GetSkuRedundancyBaseStockPageList(startTime, endtime, offset, limit, ref total);
                if (dataList.Count <= 0) break;
                foreach (var item in dataList)
                {
                    var model = new Models.dc_auto_week_redundancy_details
                    {
                        bailun_sku = item.bailun_sku,
                        total_inventory_amount = item.total_inventory_amount,
                        warehousing_time = item.first_inbound_date,
                        last_synch_time = DateTime.Now,
                        total_inventory = item.sum_usable_stock,
                        warehouse_code = item.warehouse_code,
                        create_date_time = DateTime.Now,
                        start_date = startTime,
                        end_date = endtime
                    };
                    dc_auto_week_redundancy_details_dao.Insert(model);
                    Console.WriteLine($"写入库存冗余数据：{i}---{item.bailun_sku}");
                }
            }
        }

        /// <summary>
        /// 定时执行缺货数据
        /// </summary>
        public void TimingWeekShortageTask()
        {
            int limit = 20;
            int total = 0;
            for (int i = 1; i < 30000; i++)
            {
                int offset = (i - 1) * limit;
                DateTime startTime = DateTime.Now.AddDays(-1);
                DateTime endtime = DateTime.Now;
                var dataList = dc_auto_week_shortage_dao.GetGmtOutStockPageList(startTime, endtime, offset, limit, ref total);
                if (dataList.Count <= 0) break;
                var skus = dataList.Select(x => x.bailun_sku).ToList();
                var bailun_inner_skus = dataList.Where(x => !string.IsNullOrWhiteSpace(x.bailun_inner_sku)).Select(x => x.bailun_inner_sku).ToList();
                var resultList = ApiUtility.GetPdsProviderProductSales(bailun_inner_skus);
                var findPurchases = dc_auto_week_shortage_dao.GetSkuPurchaseList(skus, startTime, endtime);
                foreach (var item in dataList)
                {
                    var purchaseModel = findPurchases.FirstOrDefault(x => x.bailun_sku == item.bailun_sku);
                    var pdsModel = resultList.FirstOrDefault(x => x.ProductCode == item.bailun_sku) ?? new Models.ApiDto.PdsProviderProductSalesDto();
                    var model = new Models.dc_auto_week_shortage_details
                    {
                        create_date_time = DateTime.Now,
                        stockout_time = item.gmt_out_stock_modified,
                        bailun_sku = item.bailun_sku,
                        last_synch_time = DateTime.Now,
                        warehouse_code = item.warehouse_code,
                        warehousing_time = item.first_inbound_date,
                        historical_sales_quantity = item.bailun_sku_quantity_ordered ?? 0,
                        historical_purchase_quantity = purchaseModel?.purchase_num ?? 0,
                        pds_item_id = pdsModel.ProductItemId,
                        first_sales_platform_average = pdsModel.FirstSalesPlatSevenTh ?? 0,
                        second_sales_platform_average = pdsModel.SecondSalesPlatSevenTh ?? 0,
                        ana_seven_days_average = pdsModel.AnaMarketVagueSevenThSales ?? 0,
                        seven_days_average = item.history_sevenday_sales_ebay??0,
                        safety_stock = item.quantity_safe??0,
                        start_date = DateHelper.GetWeekFirstDayMon(DateTime.Now.AddDays(-1)),
                        end_date = DateHelper.GetWeekLastDaySun(DateTime.Now.AddDays(-1))
                    };
                    dc_auto_week_shortage_dao.Insert(model);
                    Console.WriteLine($"写入缺货数据：{i}---{item.bailun_sku}");
                }
            }
        }
    }
}
