﻿using AutoTurnOver.Models.ApiDto;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_base_stock
    {
        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int id { get; set; }

        /// <summary>
        /// 商品编号
        /// </summary>
        [Description(@"商品编号")]
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description(@"仓库编码")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 货主编码
        /// </summary>
        [Description(@"货主编码")]
        public string owner_code { get; set; }

        /// <summary>
        /// 订货数量
        /// </summary>
        [Description(@"订货数量")]
        public int quantity_reservation { get; set; }

        /// <summary>
        /// 运输在途
        /// </summary>
        [Description(@"运输在途")]
        public int quantity_transport { get; set; }

        /// <summary>
        /// 中转仓库存
        /// </summary>
        [Description(@"中转仓库存")]
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 冻结库存
        /// </summary>
        [Description(@"冻结库存")]
        public int quantity_freeze { get; set; }

        /// <summary>
        /// 供应商库存
        /// </summary>
        [Description(@"供应商库存")]
        public int quantity_supplier { get; set; }

        /// <summary>
        /// 预售库存
        /// </summary>
        [Description(@"预售库存")]
        public int quantity_presell { get; set; }

        /// <summary>
        /// 不良品库存
        /// </summary>
        [Description(@"不良品库存")]
        public int quantity_defective { get; set; }

        /// <summary>
        /// 在途库存
        /// </summary>
        [Description(@"在途库存")]
        public int quantity_transit { get; set; }

        /// <summary>
        /// 收货待检
        /// </summary>
        [Description(@"收货待检")]
        public int wait_check { get; set; }

        /// <summary>
        /// 待上架
        /// </summary>
        [Description(@"待上架")]
        public int wait_putaway { get; set; }

        /// <summary>
        /// 可配库存
        /// </summary>
        [Description(@"可配库存")]
        public int usable_stock { get; set; }

        /// <summary>
        /// 销售可用库存(聚合)
        /// </summary>
        [Description(@"销售可用库存(聚合)")]
        public int usable_sales { get; set; }

        /// <summary>
        /// 销售可用库存(私有)
        /// </summary>
        [Description(@"销售可用库存(私有)")]
        public int usable_sales_private { get; set; }

        /// <summary>
        /// 销售可用库存(共享)
        /// </summary>
        [Description(@"销售可用库存(共享)")]
        public int usable_sales_share { get; set; }

        /// <summary>
        /// 在仓库存(共享)
        /// </summary>
        [Description(@"在仓库存(共享)")]
        public int in_warehouse_share { get; set; }

        /// <summary>
        /// 在仓库存(私有)
        /// </summary>
        [Description(@"在仓库存(私有)")]
        public int in_warehouse_private { get; set; }

        /// <summary>
        /// 在仓库存(聚合)
        /// </summary>
        [Description(@"在仓库存(聚合)")]
        public int in_warehouse { get; set; }

        /// <summary>
        /// 仓库占用(共享)
        /// </summary>
        [Description(@"仓库占用(共享)")]
        public int occupy_stock_share { get; set; }

        /// <summary>
        /// 仓库占用(私有)
        /// </summary>
        [Description(@"仓库占用(私有)")]
        public int occupy_stock_private { get; set; }

        /// <summary>
        /// 仓库占用(聚合)
        /// </summary>
        [Description(@"仓库占用(聚合)")]
        public int occupy_stock { get; set; }

        /// <summary>
        /// 活动占用
        /// </summary>
        [Description(@"活动占用")]
        public int occupy_activity { get; set; }

        /// <summary>
        /// 订单占用(私有)
        /// </summary>
        [Description(@"订单占用(私有)")]
        public int occupy_order_private { get; set; }

        /// <summary>
        /// 订单占用(共享)
        /// </summary>
        [Description(@"订单占用(共享)")]
        public int occupy_order_share { get; set; }

        /// <summary>
        /// 订单占用(聚合)
        /// </summary>
        [Description(@"订单占用(聚合)")]
        public int occupy_order { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        [Description(@"数据中心创建时间")]
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        [Description(@"数据中心更新时间")]
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 环球创建时间
        /// </summary>
        [Description(@"环球创建时间")]
        public DateTime create_time { get; set; }

        /// <summary>
        /// 环球更新时间
        /// </summary>
        [Description(@"环球更新时间")]
        public DateTime update_time { get; set; }

        /// <summary>
        /// 已发货库存
        /// </summary>
        [Description(@"已发货库存")]
        public int shipped_stock { get; set; }

        /// <summary>
        /// 中文名称
        /// </summary>
        [Description(@"中文名称")]
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 内部编码
        /// </summary>
        [Description(@"内部编码")]
        public string product_inner_code { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        [Description(@"供应商名称")]
        public string suppliers_name { get; set; }

        /// <summary>
        /// 公司Id, 默认0是无意义的
        /// </summary>
        [Description(@"公司Id, 默认0是无意义的")]
        public int company_id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public string bailun_sku_warehouse_code { get; set; }

        /// <summary>
        /// 首次入库时间
        /// </summary>
        [Description(@"首次入库时间")]
        public DateTime? first_inbound_date { get; set; }

        /// <summary>
        /// 数据特性
        /// </summary>
        [Description(@"数据特性")]
        public string character { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public string bailun_sku_warehouse_area { get; set; }

        /// <summary>
        /// 最近30天支出金额
        /// </summary>
        [Description(@"最近30天支出金额")]
        public decimal? pay_amount_30 { get; set; }

        /// <summary>
        /// 最近30天收入金额
        /// </summary>
        [Description(@"最近30天收入金额")]
        public decimal? income_amount_30 { get; set; }

        /// <summary>
        /// 可售天数
        /// </summary>
        [Description(@"可售天数")]
        public decimal? available_days { get; set; }

        /// <summary>
        /// 来源 1-dc_base_oms_sku订单 2-dc_base_purchase采购 3-dc_mid_transit周转. 0-default null-default
        /// </summary>
        [Description(@"来源 1-dc_base_oms_sku订单 2-dc_base_purchase采购 3-dc_mid_transit周转. 0-default null-default")]
        public int? source_from { get; set; }

        /// <summary>
        /// 首次采购时间
        /// </summary>
        [Description(@"首次采购时间")]
        public DateTime? first_purchase_date { get; set; }

        /// <summary>
        /// 首次调拨时间
        /// </summary>
        [Description(@"首次调拨时间")]
        public DateTime? first_trans_date { get; set; }
    }

    public class dc_base_stock_dto : dc_base_stock
    {
        /// <summary>
        /// 供应链长度所需库存
        /// </summary>
        public decimal? turnover_days_quantity { get; set; }
        /// <summary>
        /// 供应链长度
        /// </summary>
        public int? turnover_days { get; set; }
        /// <summary>
        /// 供应链长度所需库存 （缺货）
        /// </summary>
        public decimal? turnover_days_outofstock_quantity { get {
                return Math.Max(0, (turnover_days_quantity??0) - sum_actual_stock);
            } }
        /// <summary>
        /// 供应链长度所需库存 （冗余）
        /// </summary>
        public decimal? turnover_days_redundancy_quantity { get {
                return Math.Max(0, sum_actual_stock-(turnover_days_quantity??0) );
            } }


        public DateTime? lately_transfer_expect_arrival_time { get; set; }
        public string lately_transfer_order_no { get; set; }
        /// <summary>
        /// 周转表更新时间
        /// </summary>
        public DateTime? turnover_gmt_modified { get; set; }
        public decimal lately_transfer_count { get; set; }
        public string lately_transfer_trackingno { get; set; }
        public string lately_transfer_transporttype { get; set; }
        public string lately_transfer_logisticsname { get; set; }

        public int quantity_land_purchase { get; set; }
        public int quantity_ocean_purchase { get; set; }
        public int quantity_air_purchase { get; set; }
        public int quantity_railway_purchase { get; set; }
        public int quantity_land_transfer { get; set; }
        public int quantity_ocean_transfer { get; set; }
        public int quantity_air_transfer { get; set; }
        public int quantity_railway_transfer { get; set; }
        /// <summary>
        /// 入库数
        /// </summary>
        public decimal storage_quantity { get; set; }

        /// <summary>
        /// 海外仓入库天数
        /// </summary>
        public decimal? abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 在途+可配总库存
        /// </summary>
        public decimal sum_actual_stock { get; set; }

       

        /// <summary>
        /// 待调拨数量
        /// </summary>
        public decimal not_trans_count { get; set; }
        public string extend_sale_user_name { get; set; }
        public string area_name { get; set; }
        public string hq_type { get; set; }

        /// <summary>
        /// 采购在途金额
        /// </summary>
        public decimal? realtime_amount_purchase { get; set; }

        /// <summary>
        /// 总库存金额
        /// </summary>
        public decimal? sum_usable_stock_amount { get; set; }

        /// <summary>
        /// 总库存
        /// </summary>
        public decimal? sum_usable_stock { get; set; }

        /// <summary>
        /// 待发货数量
        /// </summary>
        public decimal? quantity_unshipped { get; set; }

        /// <summary>
        /// 调拨在途金额
        /// </summary>
        public decimal? realtime_amount_transfer { get; set; }
        /// <summary>
        /// 上周销售金额
        /// </summary>
        public decimal lastweek_sales_amount { get; set; }
        /// <summary>
        /// 上周销售量
        /// </summary>
        public decimal lastweek_sales { get; set; }
        /// <summary>
        /// 安全库存
        /// </summary>
        public decimal real_quantity_safe_inventory { get; set; }
        public decimal pack_length { get; set; }
        public decimal pack_width { get; set; }
        public decimal pack_height { get; set; }
        public string brand { get; set; }
        /// <summary>
        /// 可配库存金额
        /// </summary>
        public decimal usable_stock_amount { get; set; }
        /// <summary>
        /// 总在途金额
        /// </summary>
        public decimal on_the_way_stock_amount { get; set; }
        public string product_size { get; set; }
        public string tags { get; set; }
        public string product_type_desc { get; set; }
        public decimal? moq { get; set; }
        /// <summary>
        /// 昨日销量
        /// </summary>
        public decimal? oneday_sales { get; set; }
        /// <summary>
        /// 开发时间
        /// </summary>
        public DateTime? develop_time { get; set; }
        public string base_sku_name { get; set; }
        public string sku_product_inner_code { get; set; }
        public int monitor_status { get; set; }
        public string warehouse_name { get; set; }
        public string sku_name { get; set; }
        /// <summary>
        /// 内部系统采购在途
        /// </summary>
        public int? purchase_daily_quantity { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 产品中文名
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 产品英文名
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 产品内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 实时采购在途
        /// </summary>
        public int realtime_quantity_purchase { get; set; }

        /// <summary>
        /// 实时调拨在途
        /// </summary>
        public int realtime_quantity_transfer { get; set; }

        public string suppliers_name { get; set; }

        public decimal? quantity_out_stock { get; set; }

        public DateTime? gmt_out_stock_modified { get; set; }

        /// <summary>
        /// 重量
        /// </summary>
        public decimal? weight { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal? unit_price { get; set; }

        public string has_tort { get; set; }

        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 过去14日日均销量
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }

        /// <summary>
        /// 过去30天日均销量
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }
        /// <summary>
        /// 过去7日销量(日均)
        /// </summary>
        public decimal history_sevenday_sales_ebay { get; set; }
        /// <summary>
        /// /// <summary>
        /// 过去14日销量(日均) - ebay
        /// </summary>
        /// </summary>
        public decimal history_fourteenday_sales_ebay { get; set; }
        /// <summary>
        /// /// <summary>
        /// 过去30日销量(日均) - ebay
        /// </summary>
        /// </summary>
        public decimal history_thirtyday_sales_ebay { get; set; }
        public decimal history_sevenday_sales_aliexpress { get; set; }
        public decimal history_fourteenday_sales_aliexpress { get; set; }
        public decimal history_thirtyday_sales_aliexpress { get; set; }
        public decimal history_sevenday_sales_amazon { get; set; }
        public decimal history_fourteenday_sales_amazon { get; set; }
        public decimal history_thirtyday_sales_amazon { get; set; }

        /// <summary>
        /// Walmart 过去7日销量（日均) 
        /// </summary>
        public decimal history_sevenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去14日销量（日均)
        /// </summary>
        public decimal history_fourteenday_sales_walmart { get; set; }
        /// <summary>
        /// Walmart 过去30日销量（日均)
        /// </summary>
        public decimal history_thirtyday_sales_walmart { get; set; }


        public string category_simple_name { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int? sku_status { get; set; }

        public string sku_status_str
        {
            get
            {
                if (sku_status == null) return "";
                return ((sku_status_enum)sku_status).ToString();
            }
        }

        public enum sku_status_enum
        {
            停售 = 1,
            在售 = 2
        }


        /// <summary>
        /// 调拨单在途
        /// </summary>
        public int quantity_transfer_order { get; set; }
        public decimal? quantity_transfer_order_amount { get; set; }

        /// <summary>
        /// 调拨单采购临时数据
        /// </summary>
        public int quantity_transfer_temp_schedule { get; set; }
        public decimal? quantity_transfer_temp_schedule_amount { get; set; }

        /// <summary>
        /// 调拨在途，暂存
        /// </summary>
        public int quantity_transfer_temporary_storage { get; set; }
        public decimal? quantity_transfer_temporary_storage_amount { get; set; }
    }

    public class dc_base_stock_fba_dto
    {
        public DateTime? lately_transfer_expect_arrival_time { get; set; }
        public string lately_transfer_order_no { get; set; }
        public decimal lately_transfer_count { get; set; }
        public string lately_transfer_trackingno { get; set; }
        public string lately_transfer_transporttype { get; set; }
        public string lately_transfer_logisticsname { get; set; }
        public int quantity_land_purchase { get; set; }
        public int quantity_ocean_purchase { get; set; }
        public int quantity_air_purchase { get; set; }
        public int quantity_railway_purchase { get; set; }
        public int quantity_land_transfer { get; set; }
        public int quantity_ocean_transfer { get; set; }
        public int quantity_air_transfer { get; set; }
        public int quantity_railway_transfer { get; set; }
        public string bailun_account { get; set; }
        public decimal? sum_stock { get; set; }
        public string web_site { get; set; }
        public string asin { get; set; }
        public string bailun_sku { get; set; }
        public string product_type { get; set; }
        public string group_name { get; set; }
        public string sale_name { get; set; }
        public string sku_title_cn { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public string area_name { get; set; }
        public decimal? amount_sales_usd_1 { get; set; }
        public decimal? bailun_sku_quantity_ordered_1 { get; set; }
        public decimal? amount_sales_usd_7 { get; set; }
        public decimal? bailun_sku_quantity_ordered_7 { get; set; }
        public decimal? amount_sales_usd_30 { get; set; }
        public decimal? bailun_sku_quantity_ordered_30 { get; set; }
        public decimal amount_sales_usd_month_1 { get; set; }
        public decimal bailun_sku_quantity_ordered_month_1 { get; set; }
        public decimal amount_sales_usd_month_2 { get; set; }
        public decimal bailun_sku_quantity_ordered_month_2 { get; set; }

        public int monitor_status { get; set; }
        public string buyer_name { get; set; }
        public decimal? unit_price { get; set; }
        public decimal? weight { get; set; }
        public decimal? quantity_purchase { get; set; }
        public decimal? quantity_transfer { get; set; }
        public decimal? quantity_transfer_order { get; set; }
        public decimal? quantity_transfer_temp_schedule { get; set; }
        public decimal? quantity_transfer_temporary_storage { get; set; }
        public decimal? sum_mid { get; set; }
        public decimal? usable_stock_01 { get; set; }
        public decimal? usable_stock_02 { get; set; }
        public decimal? usable_stock { get; set; }
        public decimal? sum_mid_amount { get; set; }
        public decimal? usable_stock_amount { get; set; }
        public decimal? sum_amount { get; set; }
        public decimal? review_count { get; set; }
        public decimal? review_score { get; set; }

    }

    public class dc_base_stock_search_dto
    {
        [Description("监控状态")]
        public int? monitor_status { get; set; }
        [Description("单号")]
        public string order_no { get; set; }

        [Description("Asin")]
        public string asin { get; set; }
        public bool isSum { get; set; }
        public bool is_warehouse_sum { get; set; }

        public int? searchType { get; set; }

        [Description("搜索关键词")]
        public string key_words { get; set; }

        [Description("仓库编码")]
        public string warehousecode { get; set; }

        [Description("采购员")]
        public string buyer_name { get; set; }

        [Description("供应商")]
        public string supplier_name { get; set; }
        public int offset { get; set; }
        public int limit { get; set; }
        public string order { get; set; }
        public string sort { get; set; }

        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }
        public int? has_tort { get; set; } = null;

        [Description("分类")]
        public string categoryIds { get; set; } = null;

        [Description("入库时间（起）")]
        public DateTime? start_date { get; set; } = null;
        [Description("入库时间（止）")]
        public DateTime? end_date { get; set; } = null;
        [Description("首次入库时间（起）")]
        public DateTime? f_start_date { get; set; } = null;
        [Description("首次入库时间（止）")]
        public DateTime? f_end_date { get; set; } = null;

        [Description("产品类型")]
        public int? product_type { get; set; } = null;
    }

    public class dc_base_full_link_search_dto
    {
        [Description("监控状态")]
        public int? monitor_status { get; set; }
        [Description("调拨单号")]
        public string order_no { get; set; }
        [Description("采购单号")]
        public string order_no2 { get; set; }
        [Description("Asin")]
        public string asin { get; set; }
        public bool isSum { get; set; }
        public bool is_warehouse_sum { get; set; }

        public int? searchType { get; set; }

        [Description("搜索关键词")]
        public string key_words { get; set; }

        [Description("仓库编码")]
        public string warehousecode { get; set; }

        [Description("采购员")]
        public string buyer_name { get; set; }

        [Description("供应商")]
        public string supplier_name { get; set; }
        public int offset { get; set; }
        public int limit { get; set; }
        public string order { get; set; }
        public string sort { get; set; }

        [Description("仓库类型")]
        public string warehousetype { get; set; }

        [Description("仓库国家")]
        public int? warehousearea { get; set; }
        public int? has_tort { get; set; } = null;

        [Description("分类")]
        public string categoryIds { get; set; } = null;

        [Description("入库时间（起）")]
        public DateTime? start_date { get; set; } = null;
        [Description("入库时间（止）")]
        public DateTime? end_date { get; set; } = null;
        [Description("首次入库时间（起）")]
        public DateTime? f_start_date { get; set; } = null;
        [Description("首次入库时间（止）")]
        public DateTime? f_end_date { get; set; } = null;

        [Description("产品类型")]
        public int? product_type { get; set; } = null;
    }
}
