﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{

    /// <summary>
    /// 物流渠道
    /// </summary>
    public class dc_base_lms_channel
    {
        public int id { get; set; }
        public int lms_id { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        [Description("名称")]
        public string name { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        [Description("编码")]
        public string code { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        [Description("供应商id")]
        public int company_id { get; set; }

        /// <summary>
        /// 运输方式 1= 陆运 2 = 海运 3= 空运
        /// </summary>
        [Description("运输方式 1= 陆运 2 = 海运 3= 空运 5 = 无")]
        public int transport_type { get; set; }

        /// <summary>
        /// 揽收时效 最快
        /// </summary>
        [Description("揽收时效 最快")]
        public int? speed_collect_fastest { get; set; }

        /// <summary>
        /// 揽收时效 最慢
        /// </summary>
        [Description("揽收时效 最慢")]
        public int? speed_collect_slowest { get; set; }

        /// <summary>
        /// 上网时效 最快
        /// </summary>
        [Description("上网时效 最快")]
        public int? speed_ascan_fastest { get; set; }

        /// <summary>
        /// 上网时效 最慢
        /// </summary>
        [Description("上网时效 最慢")]
        public int? speed_ascan_slowest { get; set; }

        /// <summary>
        /// 货币单位
        /// </summary>
        [Description("货币单位")]
        public string monetary_unit { get; set; }

        /// <summary>
        /// 可发平台
        /// </summary>
        [Description("可发平台")]
        public string platform_content { get; set; }

        /// <summary>
        /// 邮递方式
        /// </summary>
        [Description("邮递方式")]
        public int post_way { get; set; }

        /// <summary>
        /// 物流网址3
        /// </summary>
        [Description("物流网址3")]
        public string official_website3 { get; set; }

        /// <summary>
        /// 不可发的产品特性id
        /// </summary>

        [Description("不可发的产品特性id")]
        public string Electrified_TypeVal { get; set; }

        /// <summary>
        /// 物流网址2
        /// </summary>
        [Description("物流网址2")]
        public string official_website2 { get; set; }

        /// <summary>
        /// 物流网址
        /// </summary>
        [Description("物流网址")]
        public string official_website { get; set; }

        /// <summary>
        /// 到港时效 最快
        /// </summary>
        [Description("到港时效 最快")]
        public int? speed_arrival_fastest { get; set; }

        /// <summary>
        /// 到港时效 最慢
        /// </summary>
        [Description("到港时效 最慢")]
        public int? speed_arrival_slowest { get; set; }

        /// <summary>
        /// 上航时效 最快
        /// </summary>
        [Description("上航时效 最快")]
        public int? speed_flight_fastest { get; set; }

        /// <summary>
        /// 上航时效 最慢
        /// </summary>
        [Description("上航时效 最慢")]
        public int? speed_flight_slowest { get; set; }

        /// <summary>
        /// 分拨中心转运时效上 最快
        /// </summary>
        [Description("分拨中心转运时效 最快")]
        public int? speed_transport_fastest { get; set; }

        /// <summary>
        /// 分拨中心转运时效 最慢
        /// </summary>
        [Description("分拨中心转运时效 最慢")]
        public int? speed_transport_slowest { get; set; }

        /// <summary>
        /// 清关时效 最快
        /// </summary>
        [Description("清关时效 最快")]
        public int? speed_customs_clearance_fastest { get; set; }

        /// <summary>
        /// 清关时效 最慢
        /// </summary>
        [Description("清关时效 最慢")]
        public int? speed_customs_clearance_slowest { get; set; }

        /// <summary>
        /// 签收时效 最快
        /// </summary>
        [Description("签收时效 最快")]
        public int? speed_sign_fastest { get; set; }

        /// <summary>
        /// 签收时效 最慢
        /// </summary>
        [Description("签收时效 最慢")]
        public int? speed_sign_slowest { get; set; }

        /// <summary>
        /// 入库时效 最快
        /// </summary>
        [Description("入库时效 最快")]
        public int? speed_put_fastest { get; set; }

        /// <summary>
        /// 入库时效 最慢
        /// </summary>
        [Description("入库时效 最慢")]
        public int? speed_put_slowest { get; set; }

        /// <summary>
        /// 取整方式  1= 四舍五入 2= 进一 3 = 去尾
        /// </summary>
        [Description("取整方式  1= 四舍五入 2= 进一 3 = 去尾")]
        public int rounding_type { get; set; }

        /// <summary>
        /// 是否记泡
        /// </summary>
        [Description("是否记泡")]
        public int has_bubble { get; set; }

        /// <summary>
        /// 记泡值
        /// </summary>
        [Description("记泡值")]
        public int bubble_value { get; set; }

        /// <summary>
        /// 重量上限 （kg）
        /// </summary>
        [Description("重量上限 （kg）")]
        public decimal shipping_rules_weight_upper_limit { get; set; }

        /// <summary>
        /// 重量下限 （kg）
        /// </summary>
        [Description("重量下限 （kg）")]
        public decimal shipping_rules_weight_lower_limit { get; set; }

        /// <summary>
        /// 限高 （cm）
        /// </summary>
        [Description("限高 （cm）")]
        public decimal shipping_rules_high_upper_limit { get; set; }

        // <summary>
        /// 限长 （cm）
        /// </summary>
        [Description("限长 （cm）")]
        public decimal shipping_rules_long_upper_limit { get; set; }

        // <summary>
        /// 限宽 （cm）
        /// </summary>
        [Description("限宽 （cm）")]
        public decimal shipping_rules_width_upper_limit { get; set; }

        // <summary>
        /// 计算周长时，长要乘的倍数
        /// </summary>
        [Description("计算周长时，长要乘的倍数")]
        public decimal shipping_rules_long_multiple { get; set; }

        // <summary>
        /// 计算周长时，宽要乘的倍数
        /// </summary>
        [Description("计算周长时，宽要乘的倍数")]
        public decimal shipping_rules_width_multiple { get; set; }

        // <summary>
        /// 计算周长时，高要乘的倍数
        /// </summary>
        [Description("计算周长时，高要乘的倍数")]
        public decimal shipping_rules_high_multiple { get; set; }

        // <summary>
        /// 周长上限 （cm）
        /// </summary>
        [Description("周长上限 （cm）")]
        public decimal shipping_rules_girth_upper_limit { get; set; }

        // <summary>
        /// 装箱要求
        /// </summary>
        [Description("装箱要求")]
        public string shipping_rules_encasement_requirements { get; set; }

        // <summary>
        /// 单箱最高重量（kg）
        /// </summary>
        [Description("单箱最高重量（kg）")]
        public decimal? shipping_rules_box_weight_upper_limit { get; set; }

        // <summary>
        /// 单箱最低重量（kg）
        /// </summary>
        [Description("单箱最低重量（kg）")]
        public decimal? shipping_rules_box_weight_lower_limit { get; set; }

        // <summary>
        /// 单票最高重量 （kg）
        /// </summary>
        [Description("单票最高重量 （kg）")]
        public decimal? shipping_rules_ticket_weight_upper_limit { get; set; }

        // <summary>
        /// 揽收方式 1= 上门收货 2 = 自送
        /// </summary>
        [Description("揽收方式 1= 上门收货 2 = 自送")]
        public int collect_type { get; set; }

        // <summary>
        /// 揽收范围
        /// </summary>
        [Description("揽收范围")]
        public string collect_scope { get; set; }

        // <summary>
        /// 揽收时间
        /// </summary>
        [Description("揽收时间")]
        public string collect_time_content { get; set; }

        // <summary>
        /// 对应的仓库
        /// </summary>
        [Description("对应的仓库")]
        public string warehouse_content { get; set; }

        // <summary>
        /// 第三方仓渠道
        /// </summary>
        [Description("第三方渠道")]
        public string warehouse_channel_content { get; set; }

        // <summary>
        /// 不可发的产品特性
        /// </summary>
        [Description("不可发的产品特性")]
        public string character_content { get; set; }

        // <summary>
        /// 揽收收费方式 1= 免费 2 = 按重量计费 3 = 每票
        /// </summary>
        [Description("揽收收费方式 1= 免费 2 = 按重量计费 3 = 每票")]
        public int? collect_fee_type { get; set; }

        /// <summary>
        /// 揽收费用单价
        /// </summary>
        [Description("揽收费用单价")]
        public decimal? collect_fee_unit_price { get; set; }

        /// <summary>
        /// 申报个数
        /// </summary>
        [Description("申报个数")]
        public decimal? declare_count { get; set; }

        /// <summary>
        /// 申报比例
        /// </summary>
        [Description("申报比例")]
        public decimal? declare_ratio { get; set; }

        /// <summary>
        /// 申报价值
        /// </summary>
        [Description("申报价值")]
        public decimal? declare_value { get; set; }

        /// <summary>
        /// 申报价值下限
        /// </summary>
        [Description("申报价值下限")]
        public decimal? declare_value_lower_limit { get; set; }

        /// <summary>
        /// 分区信息
        /// </summary>
        [Description("分区信息")]
        public string zone_content { get; set; }

        /// <summary>
        /// 费用
        /// </summary>
        [Description("费用")]
        public string fee_content { get; set; }

        /// <summary>
        /// 类型 Type 1 = 头程 2 = 小包  3= 海外仓 4= 国内
        /// </summary>
        [Description("类型 Type  1 = 头程 2 = 小包  3= 海外仓 4= 国内")]
        public int type { get; set; }

        /// <summary>
        /// 类型 1 = 头程 2 = 小包  3= 海外仓 (逗号分隔，支持多个类型)
        /// </summary>
        [Description("类型 扩展类型 1 = 头程 2 = 小包  3= 海外仓")]
        public string start_Point { get; set; }

        /// <summary>
        /// 状态 -2 = 驳回 -1 = 停用 0 = 待审批 1 = 审批通过 
        /// </summary>
        [Description("状态 -2 = 驳回 -1 = 停用 0 = 待审批 1 = 审批通过 ")]
        public int status { get; set; }

        /// <summary>
        /// 创建人 
        /// </summary>
        [Description("创建人 ")]
        public string create_user { get; set; }

        /// <summary>
        /// 创建时间 
        /// </summary>
        [Description("创建时间 ")]
        public DateTime create_date { get; set; }

        /// <summary>
        /// 头程的装箱要求 
        /// </summary>
        [Description("头程的装箱要求 ")]
        public string packing_require { get; set; }

        /// <summary>
        /// 运输报告 
        /// </summary>
        [Description("运输报告 ")]
        public string transportation_report { get; set; }

        /// <summary>
        /// msds 
        /// </summary>
        [Description("msds ")]
        public string msds { get; set; }

        /// <summary>
        /// 是否支持查询物流信息 0-无法查询 1-api查询 2-仅能网站查询 
        /// </summary>
        [Description("是否支持查询物流信息 0-无法查询 1-api查询 2-仅能网站查询 ")]
        public int tracking_info_status { get; set; }

        /// <summary>
        /// 是否跟踪  0-不跟踪 1-全程跟踪 2-半程跟踪
        /// </summary>
        [Description("是否跟踪  0-不跟踪 1-全程跟踪 2-半程跟踪 ")]
        public int is_trace { get; set; }

        /// <summary>
        /// 承运商
        /// </summary>
        [Description("承运商")]
        public string carrier { get; set; }

        /// <summary>
        /// 0-线下物流 1-线上物流
        /// </summary>
        [Description("0-线下物流 1-线上物流")]
        public int? online_type { get; set; }

        /// <summary>
        /// 开发组
        /// </summary>
        [Description("开发组")]
        public int? dev_team_id { get; set; }

        /// <summary>
        /// 发货数量限制
        /// </summary>
        [Description("发货数量限制")]
        public int shipping_quantity { get; set; }

        /// <summary>
        /// 特殊申报价值的国家
        /// </summary>
        [Description("特殊申报价值的国家")]
        public string declare_content { get; set; }

        /// <summary>
        /// 禁用国家
        /// </summary>
        [Description("禁用国家")]
        public string disable_country_content { get; set; }

        /// <summary>
        /// 17Track 的key
        /// </summary>
        [Description("17Track 的key")]
        public string yiQiTrack_Key { get; set; }

        /// <summary>
        /// 17Track 的key
        /// </summary>
        [Description("17Track 的Name")]
        public string yiQiTrack_Name { get; set; }

        /// <summary>
        /// 17Track 的key
        /// </summary>
        [Description("17Track 的查询关键词")]
        public string yiQiTrack_Keyword { get; set; }

        /// <summary>
        /// 包裹=0,信封=1
        /// </summary>
        [Description("包裹=0,信封=1")]
        public int pack_type { get; set; }

        /// <summary>
        /// 0 = 随时可发 1= 固定日期
        /// </summary>
        [Description("0 = 随时可发 1= 固定日期")]
        public int sail_time_type { get; set; }

        /// <summary>
        /// 截单时间
        /// </summary>
        [Description("截单时间")]
        public string sail_time_1_content { get; set; }

        /// <summary>
        /// 启航时间
        /// </summary>
        [Description("启航时间")]
        public string sail_time_2_content { get; set; }


    }
}
