﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    /// <summary>
    /// 无库仓
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class NotStockController : Controller
    {
        [HttpGet]
        public JsonResult List(int limit, int offset, string order, string sort, decimal? goods_sales_max, decimal? goods_sales_min, 
            int? source_type, int? success_states,int search_type,string key_words,DateTime? push_time_max, DateTime? push_time_min)
        {
            var m = new dc_not_stock_search_dto
            {
                goods_sales_max = goods_sales_max,
                goods_sales_min = goods_sales_min,
                source_type = source_type,
                success_states = success_states,
                search_type = search_type,
                key_words = key_words,
                push_time_min = push_time_min,
                push_time_max = push_time_max
            };

            var total = 0;
            var service = new Services.NotStockServices();
            var list = service.List(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 淘汰
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult Eliminate([FromBody]EliminateRequestDto data)
        {
            try
            {
                new Services.NotStockServices().Eliminate(data.product_inner_codes);
                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
            
        }

        [HttpPost]
        public JsonResult TransferWarehouse([FromBody]EliminateRequestDto data)
        {
            try
            {
                new Services.NotStockServices().TransferWarehouse(data.product_inner_codes);
                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }

        }
    }
}