﻿using System;
using System.Collections.Generic;
using System.Text;


namespace AutoTurnOver.Models
{
    /// <summary>
    /// 备货规则
    /// </summary>
    public class dc_auto_jit_tag
    {
        public int id { get; set; }
        public int? group_id { get; set; }
        public  string tag_name { get; set; }

        /// <summary>
        /// 1= 大于
        /// 2  =等于
        /// 3 = 小于
        /// 4 = 大于等于
        /// 5 = 小于等于
        /// </summary>
        public int is_gt_7 { get; set; }

        public decimal quantity_sales7 { get; set; }

        public decimal is_gt_14 { get; set; }

        public decimal quantity_sales14 { get; set; }

        /// <summary>
        /// 安全库存天数
        /// </summary>
        public decimal quantity_safe_inventory { get; set; }

        /// <summary>
        /// 优先级别
        /// </summary>
        public int level { get; set; }

        /// <summary>
        /// 是否需要淘汰
        /// </summary>
        public int is_eliminate { get; set; }

        public DateTime gmt_update { get; set; }

        /// <summary>
        /// 14 日销量的算法是否启用
        /// </summary>
        public int enable_14 { get; set; }

        /// <summary>
        /// 7 日销量的算法是否启用
        /// </summary>
        public int enable_7 { get; set; }
    }

    public class dc_auto_jit_tag_dto : dc_auto_jit_tag
    {
        public string group_name { get; set; }
        public string is_gt_7_str { get { return ((dc_auto_jit_tag_gt_type)is_gt_7).ToString(); } }
        public string is_gt_14_str { get { return ((dc_auto_jit_tag_gt_type)is_gt_14).ToString(); } }
    }

    public enum dc_auto_jit_tag_gt_type
    {
        大于 = 1,
等于 = 2,
小于 =3,
大于等于= 4,
小于等于= 5
    }

    public class dc_auto_jit_tag_log
    {
        public  int id { get; set; }

        public string bailun_sku { get; set; }

        public DateTime date { get; set; }

        public int tag_id { get; set; }

        public decimal quantity_sales7 { get; set; }

        public decimal quantity_sales14 { get; set; }

        public string tag_json { get; set; }

    }

    public class dc_auto_jit_tag_log_dto : dc_auto_jit_tag_log {
        public string tag_name { get; set; }
        public decimal quantity_safe_inventory { get; set; }
    }

    public class dc_auto_jit_tag_log_search_dto
    {
        public  DateTime? b_date { get; set; }

        public DateTime? e_date { get; set; }

        public string bailun_sku { get; set; }

        public int? tag_id { get; set; }
    }

}
