﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Utility;
using System.Data;
using AutoTurnOver.Common;
using System.IO;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PurchaseAdviseController : ControllerBase
    {
        /// <summary>
        /// 采购建议列表
        /// </summary>
        /// <param name="limit"></param>
        /// <param name="offset"></param>
        /// <param name="has_push"></param>
        /// <param name="sort"></param>
        /// <param name="end_date"></param>
        /// <param name="start_date"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult List(int limit, int offset, bool? has_push, string sort, DateTime? end_date, DateTime? start_date, bool? is_outofstock)
        {
            var m = new dc_auto_purchase_advise_search_dto
            {
                end_date = end_date,
                has_push = has_push,
                start_date = start_date,
                is_outofstock = is_outofstock
            };

            var total = 0;
            var list = PurchaseAdviseServices.List(m, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 采购建议列表
        /// </summary>
        /// <param name="limit"></param>
        /// <param name="offset"></param>
        /// <param name="has_push"></param>
        /// <param name="sort"></param>
        /// <param name="end_date"></param>
        /// <param name="start_date"></param>
        /// <returns></returns>
        [HttpGet]
        public string DetailList(int limit, int offset, int main_id, string sort, string sku, string warehousecode,
            DateTime? end_date, DateTime? start_date, string warehousetype, int? warehousearea, string order,
            bool? ispush = null, int? type = null, string supplier_name = null, string purchase_user = null, string product_inner_code = null, bool? is_multiple_warehouse = false)
        {
            var m = new dc_auto_purchase_advise_detailed_search_dto
            {
                main_id = main_id,
                sku = sku,
                warehouse_code = warehousecode,
                end_date = end_date,
                start_date = start_date,
                warehousearea = warehousearea,
                warehousetype = warehousetype,
                ispush = ispush,
                type = type,
                supplier_name = supplier_name,
                purchase_user = purchase_user,
                product_inner_code = product_inner_code,
                is_multiple_warehouse = is_multiple_warehouse.Value
            };

            var total = 0;
            var list = PurchaseAdviseServices.DetailList(m, offset, limit, ref total, order,sort);

            return new
            {
                rows = list,
                total = total,
            }.ToJson(false);
        }

        /// <summary>
        /// 采购建议列表
        /// </summary>
        /// <param name="limit"></param>
        /// <param name="offset"></param>
        /// <param name="has_push"></param>
        /// <param name="sort"></param>
        /// <param name="end_date"></param>
        /// <param name="start_date"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult DetailListSumFooter(int limit, int offset, int main_id, string sort, string sku, string warehousecode,
            DateTime? end_date, DateTime? start_date, string warehousetype, int? warehousearea,
            bool? ispush = null, int? type = null, string supplier_name = null, string purchase_user = null, string product_inner_code = null,bool is_multiple_warehouse = false
           )
        {
            var m = new dc_auto_purchase_advise_detailed_search_dto
            {
                main_id = main_id,
                sku = sku,
                warehouse_code = warehousecode,
                end_date = end_date,
                start_date = start_date,
                warehousearea = warehousearea,
                warehousetype = warehousetype,
                ispush = ispush,
                type = type,
                supplier_name = supplier_name,
                purchase_user = purchase_user,
                product_inner_code = product_inner_code,
                isSum = true,
                is_multiple_warehouse = is_multiple_warehouse
            };

            var total = 0;
            var list = PurchaseAdviseServices.DetailList(m, offset, limit, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_auto_purchase_advise_detailed_dto() : list[0]);
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public FileResult Export(int main_id, string sort, string sku, string warehousecode, DateTime? end_date, DateTime? start_date, string warehousetype, int? warehousearea, bool? ispush = null,bool is_multiple_warehouse = false)
        {
            var m = new dc_auto_purchase_advise_detailed_search_dto
            {
                main_id = main_id,
                sku = sku,
                warehouse_code = warehousecode,
                end_date = end_date,
                start_date = start_date,
                warehousearea = warehousearea,
                warehousetype = warehousetype,
                ispush = ispush,
                is_multiple_warehouse = is_multiple_warehouse
            };

            var total = 0;
            var list = PurchaseAdviseServices.DetailList(m, 0, int.MaxValue, ref total);

            DataTable table = new DataTable();
            string[] cols = new string[] { "初始建议数", "系统建议数", "采购数量", "是否已推送", "时间", "sku", "产品名称", "产品14日日均", "仓库编码","仓库名称",
                 "内部商品编码", "商品建议采购", "商品14日日均", "商品moq", "日均加权销量", "缺货", "调拨在途", "采购在途", "库存数",
                 "采购金额", "供应链长度", "供应商名称", "采购类型","采购员"
            };
            foreach (var item in cols)
            {
                table.Columns.Add(item);
            }

            foreach (var itemData in list)
            {
                DataRow row = table.NewRow();

                row["初始建议数"] = itemData.quantity_init_advise;
                row["系统建议数"] = itemData.quantity_final_advise;
                row["采购数量"] = itemData.quantity_actual;
                row["是否已推送"] = itemData.ispush == 1?"是":"否";
                row["时间"] = itemData.create_time_str;
                row["sku"] = itemData.bailun_sku;
                row["产品名称"] = itemData.sku_name;
                row["产品14日日均"] = itemData.history_fourteenday_sales;
                row["仓库编码"] = itemData.warehouse_code;
                row["仓库名称"] = itemData.warehouse_name;
                row["内部商品编码"] = itemData.product_inner_code;
                row["商品建议采购"] = itemData.goods_quantity_init_advise;
                row["商品14日日均"] = itemData.goods_history_fourteenday_sales;
                row["商品moq"] = itemData.goods_moq;
                row["日均加权销量"] = itemData.quantity_safe_inventory;
                row["缺货"] = itemData.quantity_out_stock;
                row["调拨在途"] = itemData.quantity_transfer;
                row["采购在途"] = itemData.quantity_purchase;
                row["库存数"] = itemData.quantity_inventory;
                row["采购金额"] = itemData.quantity_final_advise_price;
                row["供应链长度"] = itemData.turnover_days;
                row["供应商名称"] = itemData.suppliers_name;
                row["采购类型"] = itemData.type_str;
                row["采购员"] = itemData.buyer_name;
                table.Rows.Add(row);
            }

            var fileName = AppContext.BaseDirectory + @"Result\RealtimeStock\采购建议.csv";

            DataTableHelper.SaveCSV(table, fileName);

            var memory = new MemoryStream();
            using (var stream = new FileStream(fileName, FileMode.Open))
            {
                stream.CopyTo(memory);
            }
            memory.Position = 0;
            return File(memory, "text/csv", "采购建议.csv");
        }

        /// <summary>
        /// 设置采购数量
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public JsonResult SetQuantityActual(int id, int quantity_actual)
        {
            try
            {
                PurchaseAdviseServices.SetQuantityActual(id, quantity_actual);
                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }

        /// <summary>
        /// 批量设置采购数量
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult BatchSetQuantityActual([FromBody] BatchSetQuantityActualInputDataDto data)
        {
            try
            {
                PurchaseAdviseServices.BatchSetQuantityActual(data.datas);
                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }

        /// <summary>
        /// 推送采购计划
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public JsonResult PushBuySys(int limit, int offset, int main_id, string sort, string sku, string warehousecode,
            DateTime? end_date, DateTime? start_date, string warehousetype, int? warehousearea, string order,
            bool? ispush = null, int? type = null, string supplier_name = null, string purchase_user = null, string product_inner_code = null, bool? is_multiple_warehouse = false)
        {
            try
            {
                var m = new dc_auto_purchase_advise_detailed_search_dto
                {
                    main_id = main_id,
                    sku = sku,
                    warehouse_code = warehousecode,
                    end_date = end_date,
                    start_date = start_date,
                    warehousearea = warehousearea,
                    warehousetype = warehousetype,
                    ispush = false,
                    type = type,
                    supplier_name = supplier_name,
                    purchase_user = purchase_user,
                    product_inner_code = product_inner_code,
                    is_multiple_warehouse = is_multiple_warehouse.Value
                };

                var total = 0;
                var list = PurchaseAdviseServices.DetailList(m, 0, int.MaxValue, ref total);
                PurchaseAdviseServices.PushBuySys(list);


                return new JsonResult(new
                {
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }

        /// <summary>
        /// 查询采购建议
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public JsonResult DetailInfo(string sku, string warehousecode, DateTime dateTime)
        {
            try
            {
                return new JsonResult(new
                {
                    success = true,
                    data = PurchaseAdviseServices.DetailInfo(sku, warehousecode, dateTime)
                });

            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }

        /// <summary>
        /// 删除采购建议
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public JsonResult Del(int id)
        {
            try
            {
                PurchaseAdviseServices.Del(id);
                return new JsonResult(new
                {
                    success = true
                });

            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }


    }
}