﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ExceptionReminderController : ControllerBase
    {
        [HttpGet]
        public JsonResult List(int limit, int offset, string order, string sort, string sku, string warehousecode, string warehousetype, int? warehousearea,
            bool? has_overdue = null, bool? has_confirm = null, bool? has_solve = null,int? err_type = null)
        {
            var m = new dc_auto_forecast_fluctuation_search_dto
            {
                sku = sku,
                warehouse_code = warehousecode,
                has_overdue = has_overdue,
                has_confirm = has_confirm,
                has_solve = has_solve,
                warehousetype = warehousetype,
                warehousearea = warehousearea,
                err_type = err_type
            };

            var total = 0;
            var service = new Services.ExceptionReminderServices();
            var list = service.List(m, offset, limit, ref total, order, sort);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 异常提醒详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult Info(int id)
        {
            var m = new Services.ExceptionReminderServices().Info(id);

            return new JsonResult(m);
        }

        /// <summary>
        /// 确认异常
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult Confirm([FromBody]dc_auto_forecast_fluctuation m)
        {
            try
            {
                var user = AutoUtility.GetUser();
                if (user == null) return null;
                new Services.ExceptionReminderServices().Confirm(m, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false, message = ex.Message });
            }
            
        }
    }
}