﻿using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace AutoTurnOver.Common
{
    public class AutoUtility
    {
        /// <summary>
        /// 获取当前登陆用户
        /// </summary>
        /// <returns></returns>
        public static UserData GetUser()
        {
            Microsoft.AspNetCore.Http.HttpContext current = HttpContext.Current;
            try
            {
                string cookie;
                   current.Request.Cookies.TryGetValue("BLUserAcct",out cookie);
                var builder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");
                var configurationRoot = builder.Build();
              string  url = ConfigHelper.GetValue("WebHost_GetUser");
               // string url = ConfigurationManager.AppSettings["WebHost"].ToString();
                string userstr = HttpHelper.Request(url, RequestType.POST, "BLUserAcct=" + cookie);
                LoginData data = JsonConvert.DeserializeObject<LoginData>(userstr);
                if (data.code != 1)
                {
                    current.Response.StatusCode = (int)HttpStatusCode.Unauthorized;
                    return null;
                }
                else
                {
                    return data.data;
                }
            }
            catch
            {
                current.Response.StatusCode = (int)HttpStatusCode.Unauthorized;
                return null;
            }

        }

        /// <summary>
        /// 获取注销路径
        /// </summary>
        /// <returns></returns>
        public static string LoginOutUrl()
        {
            return  ConfigurationManager.AppSettings["WebHost_LoginOut"].ToString() ;
        }
    }
}
