﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 在途
    /// </summary>
    public class DailyServices
    {
        /// <summary>
        /// 查询采购在途数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public IEnumerable<dc_purchase_daily_dto> List(string sku, string warehouse_code)
        {
            return DB.daily.List(sku, warehouse_code);
        }

        /// <summary>
        /// 查询调拨在途数据
        /// </summary>
        /// <param name="sku">sku</param>
        /// <param name="warehouse_code">仓库编码</param>
        /// <returns></returns>
        public IEnumerable<dc_transfer_daily_dto> TransferList(string sku, string warehouse_code)
        {
            return DB.daily.TransferList(sku, warehouse_code);
        }
        

        public List<dc_base_stock_dto> RealtimeList(string sku, string warehouse_code, string product_inner_code, string sku_title_cn, int offset, int limit, ref int total, string warehousetype, int? warehousearea,bool isSum = false,string order = null,string sort = null)
        {
            return DB.daily.RealtimeList(sku, warehouse_code,product_inner_code,sku_title_cn,offset, limit, ref total,warehousetype,warehousearea, isSum, order, sort);
        }


        /// <summary>
        /// 在途数据
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehouse_code"></param>
        /// <param name="index"></param>
        /// <returns></returns>
        public List<dc_estimated_arrival_dto> EstimatedArrivalList(string sku, string warehouse_code, int index)
        {
            return DB.daily.EstimatedArrivalList(sku, warehouse_code, index);
        }

        /// <summary>
        /// 缺货订单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehouse_code"></param>
        /// <param name="index"></param>
        /// <returns></returns>
        public IEnumerable<dc_base_oms_sku> OutOfStockOrderList(string sku, string warehouse_code)
        {
            return DB.daily.OutOfStockOrderList(sku, warehouse_code);
        }

    }
}
