﻿using MySql.Data.MySqlClient;
using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using System.IO;
using Microsoft.Extensions.Configuration;
using AutoTurnOver.Utility;

namespace AutoTurnOver.DB
{
    public class connectionHelper
    {
        

        public static string _connStr = null;

        public static MySqlConnection _connection
        {
            get
            {
                return new MySqlConnection(connStr);
            }
        }

        public static string connStr
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(_connStr))
                {
                    return _connStr;
                }
                else
                {
                    var environmentName = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT");
                    var configurationBuilder = new ConfigurationBuilder()
                        .SetBasePath(Directory.GetCurrentDirectory())
                        .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                        .AddJsonFile($"appsettings.{environmentName}.json", true, reloadOnChange: true)
                        .AddEnvironmentVariables();
                    var configuration = configurationBuilder.Build();

                    _connStr = configuration.GetConnectionString("Default");
                    //var builder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");
                    //var configurationRoot = builder.Build();
                    //_connStr = ConfigHelper.GetValue("cnstr");
                    return _connStr;
                }
            }
        }
    }
}
