﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Base;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Text;

namespace AutoTurnOver.Services
{
   public class StockMonitorService
    {
        public Page<dc_auto_stock_monitor_dto> GetPage(dc_auto_stock_monitor_search_dto search)
        {
            return dc_auto_stock_monitor_dao.GetPage(search);
        }
        
        public Page<listing_status_view_dto> GetListingStatusPage(listing_status_view_search_dto search)
        {
            return dc_auto_stock_monitor_dao.GetListingStatusPage(search);
        }

        public List<string> GetShowField(string warehouse_code)
        {
            return dc_auto_stock_monitor_dao.GetShowField(warehouse_code);
        }

        private static int export_count = 0;
        public MemoryStream Export(UserData user, dc_auto_stock_monitor_search_dto search)
        {
            try
            {
                export_count++;
                var fileName = AppContext.BaseDirectory + $@"Result\RealtimeStock\{user.UserAccount}库存监控-{DateTime.Now.ToString("yyyyMMddHHmmss")}.csv";
                int page = 1;
                int rows = 50000;
                if (export_count == 1)
                {
                    rows = 250000;
                }

                while (true)
                {
                    search.rows = rows;
                    search.page = page;
                    var page_data = GetPage(search);
                    var list = page_data.Items;

                    if (list == null || list.Count <= 0) break;

                    DataTable table = new DataTable();
                    string[] cols = new string[] { "商品编码","sku编码", "中文标题", "开发时间","推送产品库时间", "产品类型", "商品来源", "刊登标签","侵权标签",
                        "采购员","采购成本","重量","监控状态","停售状态","国内仓缺货总数","国外仓缺货总数","广州01可用库存","广州01在途库存","广州01仓总库存","广州01仓库存总金额",
                        "海外仓uk仓在途","海外仓uk仓可配库存","海外仓us仓在途","海外仓us仓可配库存","fba仓库存","海外仓总库存金额","广州01-7天日均","广州01-消化天数","uk海外仓-7天日均","uk海外仓-消化天数",
                        "us海外仓-7天日均","us海外仓-消化天数","fba仓-7天日均","fba仓-消化天数"
            };
                    foreach (var item in cols)
                    {
                        table.Columns.Add(item);
                    }

                    foreach (var itemData in list)
                    {
                        DataRow row = table.NewRow();
                        row["商品编码"] = itemData.product_code;
                        row["sku编码"] = itemData.bailun_sku;
                        row["中文标题"] = itemData.sku_title_cn;
                        row["开发时间"] = itemData.develop_time;
                        row["推送产品库时间"] = itemData.push_time;
                        row["产品类型"] = itemData.product_type_desc;
                        row["商品来源"] = itemData.source_str;
                        row["刊登标签"] = "暂无";
                        row["侵权标签"] = "暂无";
                        row["采购员"] = itemData.buyer_name;
                        row["采购成本"] = itemData.unit_price;
                        row["重量"] = itemData.weight;
                        row["监控状态"] = itemData.monitor_status;
                        row["停售状态"] = itemData.status_str;
                        row["国内仓缺货总数"] = itemData.china_quantity_out_stock;
                        row["国外仓缺货总数"] = itemData.not_china_quantity_out_stock;
                        row["广州01可用库存"] = itemData.guangzhou01_usable_stock;
                        row["广州01在途库存"] = itemData.guangzhou01_transfer_stock;
                        row["广州01仓总库存"] = itemData.guangzhou01_stock;
                        row["广州01仓库存总金额"] = itemData.guangzhou01_stock_amount;
                        row["海外仓uk仓在途"] = itemData.haiwai_uk_transfer;
                        row["海外仓uk仓可配库存"] = itemData.haiwai_uk_usable_stock;
                        row["海外仓us仓在途"] = itemData.haiwai_us_transfer;
                        row["海外仓us仓可配库存"] = itemData.haiwai_us_usable_stock;
                        row["fba仓库存"] = itemData.fba_usable_stock;
                        row["海外仓总库存金额"] = itemData.haiwai_stock_amount;
                        row["广州01-7天日均"] = itemData.guangzhou01_history_sevenday_sales;
                        row["广州01-消化天数"] = itemData.guangzhou01_consume_days;
                        row["uk海外仓-7天日均"] = itemData.haiwai_uk_history_sevenday_sales;
                        row["uk海外仓-消化天数"] = itemData.haiwai_uk_consume_days;
                        row["us海外仓-7天日均"] = itemData.haiwai_us_history_sevenday_sales;
                        row["us海外仓-消化天数"] = itemData.haiwai_us_consume_days;
                        row["fba仓-7天日均"] = itemData.haiwai_fba_history_sevenday_sales;
                        row["fba仓-消化天数"] = itemData.fba_consume_days;
                        
                        table.Rows.Add(row);
                    }

                    CsvFileHelper.SaveCSV(table, fileName, page == 1);
                    page++;
                }



                var memory = new MemoryStream();
                using (var stream = new FileStream(fileName, FileMode.Open))
                {
                    stream.CopyTo(memory);
                }
                memory.Position = 0;
                export_count--;
                return memory;
            }
            catch (Exception)
            {
                export_count--;
                throw;
            }

        }
    }
}
