﻿using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace AutoTurnOver.Common
{
    public class AutoUtility
    {
        /// <summary>
        /// 获取当前登陆用户
        /// </summary>
        /// <returns></returns>
        public static UserData GetUser()
        {
            var userInfo = MyHttpContext.Current.Session.GetString("UserInfo");
            var saasUser = userInfo.ToObj<SaasUserInfo>();
            return new UserData
            {
                UserName = saasUser.Account,
                UserAccount = saasUser.Account,
                DepartmentName = "",//saasUser.Department==null?"":saasUser.Department.Name
                tree_menu_list = saasUser.tree_menu_list()
            };

        }

        /// <summary>
        /// 获取注销路径
        /// </summary>
        /// <returns></returns>
        public static string LoginOutUrl()
        {
            return ConfigurationManager.AppSettings["WebHost_LoginOut"].ToString();
        }
    }
}
