﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 安全库存
    /// </summary>
    public class quantity_safe_inventory_dto
    {
        public string hq_type { get; set; }
        public string warehouse_name { get; set; }
        public int sku_count { get; set; }
        public string warehouse_code { get; set; }
        public decimal real_quantity_safe_inventory { get; set; }
        public decimal real_quantity_safe_inventory_val { get {
                return Math.Round(real_quantity_safe_inventory, 2);
            } }
        public decimal usable_stock { get; set; }
        public decimal usable_stock_val
        {
            get
            {
                return Math.Round(usable_stock, 2);
            }
        }
        public decimal quantity_safe_inventory { get; set; }
        public decimal quantity_safe_inventory_val
        {
            get
            {
                return Math.Round(quantity_safe_inventory, 2);
            }
        }
        public decimal real_quantity_safe_inventory_amount { get; set; }
        public string real_quantity_safe_inventory_amount_val
        {
            get
            {
                return Math.Round(real_quantity_safe_inventory_amount, 2).ToString("C");
            }
        }
    }

    public class quantity_safe_inventory_search_dto: page_search_dto
    {
        public string warehousetype { get; set; }
        public int? warehousearea { get; set; }
        public string warehouse_code { get; set; }
        public bool is_sum { get; set; }
    }
}
