﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 现金流
    /// </summary>
    public class dc_report_cash_flow_log
    {
        public int id { get; set; }

        public string warehouse_code { get; set; }
        public string platform_type { get; set; }
        public string bailun_sku { get; set; }
        /// <summary>
        /// 1 = 销售数量 2 = 售金额 3 = 退款  4 = 利润  5 =平台费用  6=释放销售成本  7 = 释放头程费用  8 = 尾程费用  9 = 新增采购费用 10 =  新增头程费用
        /// </summary>
        public int data_type { get; set; }
        /// <summary>
        /// 1 = 实时  2 = 后付 3 = 后收 4 =预付
        /// </summary>
        public int pay_type { get; set; }
        /// <summary>
        /// 发送数值
        /// </summary>
        public decimal val { get; set; }
        /// <summary>
        /// 发送时间
        /// </summary>
        public DateTime occur_time { get; set; }
        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime pay_time { get; set; }
        /// <summary>
        /// 相关单号
        /// </summary>
        public string no { get; set; }
        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }
        /// <summary>
        /// 项目编号
        /// </summary>
        public string item_no { get; set; }
        public string web_site { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remarks { get; set; }

        /// <summary>
        /// 是否作废
        /// </summary>
        public int is_delete { get; set; }
        public DateTime update_time { get; set; }
        public string pay_time_year_month_no { get; set; }
        public string occur_time_year_month_no { get; set; }
    }

    public class old_cash_flow_dto
    {
        public int id { get; set; }
        public int data_type { get; set; }
    }

    public class dc_report_cash_flow_log_dto : dc_report_cash_flow_log
    {
        public string sys_url { 
            get
            {
                if(
                    (int)dc_report_cash_flow_log_data_type_enum.FBA费== data_type 
                    || (int)dc_report_cash_flow_log_data_type_enum.PayPal费 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.利润 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.尾程费用 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.平台费用 == data_type
                   
                    || (int)dc_report_cash_flow_log_data_type_enum.释放头程费用 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.释放销售成本 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.销售数量 == data_type
                    || (int)dc_report_cash_flow_log_data_type_enum.销售金额 == data_type
                    )
                {
                    return "http://oms.bailuntec.com/#/bailun-order/all-orders?baseQueryKey=BailunOrderNo&baseQueryValue="+no;
                }
                else if((int)dc_report_cash_flow_log_data_type_enum.新增头程费用 == data_type || (int)dc_report_cash_flow_log_data_type_enum.新增头程费用_首单 == data_type)
                {
                    return "http://trans.bailuntec.com/#/allot-manage/ordinaryAllotOrderList?ordercode=" + no;
                }
                else if ((int)dc_report_cash_flow_log_data_type_enum.新增采购费用 == data_type || (int)dc_report_cash_flow_log_data_type_enum.新增采购费用_首单 == data_type)
                {
                    return "http://api.purchase.bailuntec.com/Purchase/Home/ApiDetail2?buyno=" + no;
                }  else if ((int)dc_report_cash_flow_log_data_type_enum.退款 == data_type)
                {
                    return "http://crm.bailuntec.com/CustomerService/Detail?id=" + item_no;
                }
                else
                {
                    return null;
                }
            } }
        public string data_type_str
        {
            get
            {
                return ((dc_report_cash_flow_log_data_type_enum)data_type).ToString();
            }
        }
        public string pay_type_str
        {
            get
            {
                return ((dc_report_cash_flow_log_pay_type_enum)pay_type).ToString();
            }
        }

        public string warehouse_name { get; set; }
        public int type { get; set; }
        public DateTime show_time { get
            {
                if (type == 1) return occur_time;
                else return pay_time;
            } }
    }

    /// <summary>
    ///  1 = 销售数量 2 = 销售金额 3 = 退款  4 = 利润  5 =平台费用  6=释放销售成本  7 = 释放头程费用  8 = 尾程费用  9 = 新增采购费用 10 =  新增头程费用
    /// </summary>
    public enum dc_report_cash_flow_log_data_type_enum
    {
        销售数量 = 1,
        销售金额 = 2,
        退款 = 3,
        利润 = 4,
        平台费用 = 5,
        释放销售成本 = 6,
        释放头程费用 = 7,
        尾程费用 = 8,
        新增采购费用 = 9,
        新增头程费用 = 10,
        FBA费 = 11,
        PayPal费 = 12,
        新增采购费用_首单 = 13,
        新增头程费用_首单 = 14,
        广告费 = 15,
        上架费 = 16
    }

    public enum dc_report_cash_flow_log_pay_type_enum
    {
        实时 = 1,
        后付 = 2,
        后收 = 3,
        预付 = 4,
    }
    public enum dc_report_cash_flow_settlement_type_enum
    {
        等长顺延 = 1,
        月度固定 = 2,
        月度固定_下期付款 = 3,
    }

    /// <summary>
    /// 现金流配置
    /// </summary>
    public class dc_report_cash_flow_config
    {
        public int id { get; set; }
        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }
        public string web_stite { get; set; }

        /// <summary>
        /// 数据类型
        /// </summary>
        public int data_type { get; set; }

        /// <summary>
        /// 结算方式
        /// </summary>
        public int settlement_type { get; set; }


        public int settlement_val { get; set; }
    }

    public class dc_report_cash_flow_config_search_dto
    {
        public string data_type { get; set; }
    }
    public class dc_report_cash_flow_config_dto : dc_report_cash_flow_config
    {
        public string data_type_str
        {
            get
            {
                return ((dc_report_cash_flow_log_data_type_enum)data_type).ToString();
            }
        }

        public string settlement_type_str
        {
            get
            {
                return ((dc_report_cash_flow_settlement_type_enum)settlement_type).ToString();
            }
        }

    }


    public class report_cash_flow_view_dto
    {
        public string remarks { get; set; }
        public string date_type_str { get; set; }
        public List<int> date_type { get; set; }
        public List<date_dto> dates { get; set; }
        public class date_dto
        {
            public string date_title { get; set; }

            public DateTime btime { get; set; }
            public DateTime etime { get; set; }
            public decimal occur_val { get; set; }
            public decimal pay_val { get; set; }
        }
    }

    public class report_cash_flow_view_search_dto
    {
        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
        public string platform_type { get; set; }
        public string web_site { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
    }

    public class dc_report_cash_flow_log_export_search_dto
    {
        public DateTime? btime { get; set; }
        public bool issum { get; set; }
        public DateTime? etime { get; set; }
        public List<int> data_type { get; set; }
        /// <summary>
        /// 1 = 根据发生时间查询
        /// 2 = 根据支付时间查询
        /// </summary>
        public int? type { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public string platform_type { get; set; }
        public string web_site { get; set; }
        public int? view_type { get; set; }
    }

    public class dc_report_cash_flow_log_export_page_search_dto: page_search_dto
    {
        public DateTime? btime { get; set; }
        public bool issum { get; set; }
        public DateTime? etime { get; set; }
        public List<int> data_type { get; set; }
        /// <summary>
        /// 1 = 根据发生时间查询
        /// 2 = 根据支付时间查询
        /// </summary>
        public int? type { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public string platform_type { get; set; }
        public string web_site { get; set; }
        public int? view_type { get; set; }
    }

    public class dc_report_cash_flow_sku_group
    {
        public int id { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public decimal balance { get; set; }
        public decimal last_balance { get; set; }
        public decimal current_balance { get; set; }
        public DateTime current_date_begin { get; set; }
        public DateTime current_date_end { get; set; }
        public DateTime last_date_begin { get; set; }
        public DateTime last_date_end { get; set; }
        public decimal current_income { get; set; }
        public decimal current_expend { get; set; }
        public decimal last_income { get; set; }
        public decimal last_expend { get; set; }
        public decimal type { get; set; }
    }
    public class dc_report_cash_flow_sku_group_dto : dc_report_cash_flow_sku_group
    {
        public string sku_name { get; set; }
        public int sku_status { get; set; }
        public string buyer_name { get; set; }
        public string warehouse_name { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public decimal usable_stock { get; set; }
        /// <summary>
        /// 在途数量
        /// </summary>
        public decimal on_the_way { get; set; }
        /// <summary>
        /// 在途金额
        /// </summary>
        public decimal on_the_way_amount { get; set; }
        /// <summary>
        /// 库存金额
        /// </summary>
        public decimal stock_amount { get; set; }
        /// <summary>
        /// 过去7天日均
        /// </summary>
        public decimal history_sevenday_sales { get; set; }
        /// <summary>
        /// 过去14天日均
        /// </summary>
        public decimal history_fourteenday_sales { get; set; }
        /// <summary>
        /// 过去30天日均
        /// </summary>
        public decimal history_thirtyday_sales { get; set; }
    }

    public class dc_report_cash_flow_sku_group_search_dto : page_search_dto
    {
        public string bailun_sku { get; set; }
       
        public int? data_type { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }

        public string warehouse_code { get; set; }

        public string sku_label { get; set; }

        /// <summary>
        /// 监控状态 
        /// 1= 停止监控
        /// 0 = 开启监控
        /// </summary>
        public int? monitor_status { get; set; }

        public string buyer_name { get; set; }
        public string supplier_name { get; set; }
        public string product_type { get; set; }
    }

    public class dc_report_cash_flow_platform_share_dto
    {
        public string platform_type { get; set; }
        public string web_stie { get; set; }

        /// <summary>
        /// 加权销量
        /// </summary>
        public decimal sales_7 { get; set; }
        public decimal sales_14 { get; set; }
        public decimal sales_30 { get; set; }
        /// <summary>
        /// 最终加权销量
        /// </summary>
        public decimal sales_weight { get; set; }
        /// <summary>
        /// 占比
        /// </summary>
        public decimal ratio { get; set; }
    }
}
