﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 安全库存规则
    /// </summary>
    public class dc_auto_config_safe_inventory
    {
        public int id { get; set; }
        public DateTime gmt_create { get; set; }
        public DateTime gmt_modified { get; set; }
        
        public string variable_code { get; set; }

        public string variable_name { get; set; }

        public string warehouse_code { get; set; }

        public string warehouse_name { get; set; }

        public string bl_operator { get; set; }

        public string remark { get; set; }

        /// <summary>
        /// 1启用, 2停用
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 7 天加权 
        /// </summary>
        public decimal weighting_coefficient_seven { get; set; }

        /// <summary>
        /// 14 天加权
        /// </summary>
        public decimal weighting_coefficient_fourteen { get; set; }

        /// <summary>
        /// 30 天加权
        /// </summary>
        public decimal weighting_coefficient_thirty { get; set; }


        /// <summary>
        /// 手动指定安全库存 ( type 为3时，此处为倍数 )
        /// </summary>
        public decimal param { get; set; }

        /// <summary>
        /// 类型
        /// </summary>
        public int type { get; set; }

        
    }
    public class dc_auto_config_safe_inventoryDto: dc_auto_config_safe_inventory
    {
        public string typeStr
        {
            get
            {
                return ((Safe_inventoryType)(type)).ToString();
            }
        }
    }
    public enum Safe_inventoryType
    {
        仓库_SKU_定值 = 1,
        仓库_分类_定值 = 2,
        仓库_按历史计算 = 3,
        仓库_SKU_按历史计算 = 11,
        仓库_SKU_按预测计算 = 12
    }
}
