﻿using AutoTurnOver.Models;
using AutoTurnOver.Models.Report;
using Dapper;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using AutoTurnOver.Models.Base;
using AutoTurnOver.DB.Base;
using AutoTurnOver.Utility;
using AutoTurnOver.Models.ApiDto;
using AutoTurnOver.Models.stock;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// 半成品仓库存
    /// </summary>
   public  class wip_stock_dao : connectionHelper
    {
        /// <summary>
        /// 同步数据
        /// </summary>
        public static void Synchronization()
        {
            var conn = _connection;
            int page = 0;
            int rows = 5000;
            var dc_base_wip_warehouse_list = new List<dc_base_wip_warehouse>();
            while (true)
            {
                page++;
                var datas = GetPageData(page, rows);
                if (datas.Count <= 0)
                {
                    break;
                }
                dc_base_wip_warehouse_list.AddRange(datas.GroupBy(s=>new { s.warehouse_id}).Select(s=>new dc_base_wip_warehouse { warehouse_code = s.Key.warehouse_id.ToString(),warehouse_name = s.Max(v=>v.warehouse_name)}));
                foreach (var item in datas)
                {
                    var new_data = new dc_base_wip_stock
                    {
                        bailun_sku = item.material_code,
                        quantity_safe_inventory = item.safe_inventory,
                        sku_name = item.material_name,
                        unit_price = item.new_price ?? 0,
                        usable_stock = item.stock,
                        warehouse_code = item.warehouse_id.ToString()
                    };
                    var old_data = conn.QuerySingleOrDefault<dc_base_wip_stock>(" select * from dc_base_wip_stock where warehouse_code=@warehouse_code and bailun_sku=@bailun_sku ", new { warehouse_code = new_data.warehouse_code, bailun_sku = new_data.bailun_sku });
                    if (old_data != null)
                    {
                        new_data.id = old_data.id;
                        conn.Update(new_data);
                    }
                    else
                    {
                        conn.Insert(new_data);
                    }
                }
            }

            if (dc_base_wip_warehouse_list != null)
            {
                foreach (var item in dc_base_wip_warehouse_list)
                {
                    // 检查是否存在
                    var old_data = conn.QuerySingleOrDefault<dc_base_wip_warehouse>(" select * from dc_base_wip_warehouse where warehouse_code=@warehouse_code ",new { warehouse_code = item.warehouse_code });
                    if (old_data != null)
                    {
                        item.id = old_data.id;
                        conn.Update(item);
                    }
                    else
                    {
                        conn.Insert(item);
                    }
                }
            }
        }

        /// <summary>
        /// 账号列表
        /// </summary>
        public static List<wip_material_full_stock_dto> GetPageData(int page,int rows)
        {
            string url = ConfigHelper.GetValue("WipStockUrl");
            string resultStr = HttpHelper.Request(url, RequestType.POST, new {page = page,rows =rows }.ToJson(), timeout: 1000 * 60 * 60 * 24,entype:"application/json");
            var result = resultStr.ToObj<wip_sys_api_dto>();
            if (result == null)
            {
                throw new Exception("账号系统异常： 未获取到数据");
            }
            if (!result.success)
            {
                throw new Exception("账号系统异常： " + result.message);
            }
            return result.data.items;
        }
    }
}
