﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
    public class ResetOutofstockBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {

            Task.Factory.StartNew(() =>
            {
                Thread.Sleep(10 * 1000);
                try
                {
                    Console.WriteLine($"fba 1/2 月销量 开始  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    //daily.ResetFbaExtendSales(DateTime.Now);
                    Console.WriteLine($"fba 1/2 月销量 结束，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                catch (Exception ex)
                {
                    Console.WriteLine(" fba 1/2 月销量 异常 :" + ex.Message);
                    Console.WriteLine(" fba 1/2 月销量 异常: " + ex.StackTrace);
                }

            });




            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步调拨 采购临时数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        //dc_base_trans_temp_schedule_dao.SynchroTransTempScheduleData();
                        dc_base_trans_temp_schedule_dao.SynchroTransTempScheduleData(true);
                        Console.WriteLine($"结束 同步调拨 采购临时数据 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步调拨 采购临时数据:" + ex.Message);
                        Console.WriteLine("同步调拨 采购临时数据:" + ex.StackTrace);
                    }
                    Thread.Sleep(10 * 60 * 1000);
                }

            });


            Task.Factory.StartNew(() =>
            {

                while (true)
                {
                    Thread.Sleep(10 * 60 * 1000);
                    try
                    {
                        Console.WriteLine($"开始 同步生产订单数据  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_prod_order_dao.SynchroData();
                        Console.WriteLine($"结束 同步生产订单数据 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步生产订单数据:" + ex.Message);
                        Console.WriteLine("同步生产订单数据:" + ex.StackTrace);
                    }

                }

            });
            Task.Factory.StartNew(() =>
           {
               while (true)
               {
                   Thread.Sleep(10 * 60 * 1000);
                   try
                   {
                       Console.WriteLine($"开始 同步调拨单当前节点  ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       dc_base_transfer_extend_dao.SynchroLmsTransferOrder();
                       Console.WriteLine($"结束 同步调拨单当前节点 ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("同步调拨单当前节点:" + ex.Message);
                       Console.WriteLine("同步调拨单当前节点:" + ex.StackTrace);
                   }

               }

           });


            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_supplier_dao.SynchroBailunSupplier();
                        Console.WriteLine($"结束 同步供应商数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步供应商数据:" + ex.Message);
                        Console.WriteLine("同步供应商数据:" + ex.StackTrace);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        wip_stock_dao.Synchronization();
                        Console.WriteLine($"结束 同步半成品库存数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("同步半成品库存数据:" + ex.Message);
                        Console.WriteLine("同步半成品库存数据:" + ex.StackTrace);
                    }


                    Thread.Sleep(60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        var now = DateTime.Now;
                        if (now.Hour > 0 && now.Hour <= 8)
                        {
                            Console.WriteLine("  刷新缺货明细数据 * (数据库忙时，暂停)");
                        }
                        else
                        {
                            Console.WriteLine($"开始刷新数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetOutofstock();
                            Console.WriteLine($"结束刷新数据任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }

                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新数据:" + ex.Message);
                        Console.WriteLine("开始刷新数据:" + ex.StackTrace);
                    }


                    Thread.Sleep(4 * 60 * 60 * 1000);
                }
            });


            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        if (DateTime.Now.Hour >= 8)
                        {

                            Console.WriteLine($"开始刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                            report.ResetStockMonitorData();
                            Console.WriteLine($"结束刷新库存监控数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新库存监控数据:" + ex.Message);
                        Console.WriteLine("开始刷新库存监控数据:" + ex.StackTrace);
                    }

                    Thread.Sleep(4 * 60 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report_cash_flow_dao.SynchroTransferCost();
                        Console.WriteLine($"结束同步真实调拨费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始同步真实调拨费:" + ex.Message);
                        Console.WriteLine("开始同步真实调拨费:" + ex.StackTrace);
                    }

                    Thread.Sleep(60 * 60 * 1000);
                }
            });
            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新最快到货的调拨单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_transfer_extend_dao.ResetData();
                        Console.WriteLine($"结束刷新最快到货的调拨单数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("开始刷新最快到货的调拨单数据:" + ex.Message);
                        Console.WriteLine("开始刷新最快到货的调拨单数据:" + ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 已经停止监控的周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_turnover.ResetHistory();
                        Console.WriteLine($"结束刷新 已经停止监控的周转数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("已经停止监控的周转数据:" + ex.Message);
                        Console.WriteLine("已经停止监控的周转数据:" + ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 商品报表库存字段增量刷新，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report.SynchroReportGoodsStockData();
                        report.SynchroReportGoodsOnTheWayData();
                        Console.WriteLine($"结束刷新 商品报表库存字段增量刷新，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("商品报表库存字段增量刷新:" + ex.Message);
                        Console.WriteLine("商品报表库存字段增量刷新" + ex.StackTrace);
                    }

                    Thread.Sleep(60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 增量刷新周转利润分析，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_turnover.SynchroCalculationProfitAnalysis();
                        Console.WriteLine($"结束刷新 增量刷新周转利润分析，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("增量刷新周转利润分析:" + ex.Message);
                        Console.WriteLine("增量刷新周转利润分析:" + ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"开始刷新 增量刷新周转扩展字段，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_turnover.Synchrofull_stock_use_days_turnover_sales();
                        Console.WriteLine($"结束刷新 增量刷新周转扩展字段，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("增量刷新周转利润分析:" + ex.Message);
                        Console.WriteLine("增量刷新周转利润分析:" + ex.StackTrace);
                    }

                    Thread.Sleep(10 * 60 * 1000);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    Thread.Sleep(10 * 60 * 1000);
                    try
                    {
                        Console.WriteLine($"开始刷新 全链路在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_base_full_link_wait_order_dao.ResetDatas();
                        Console.WriteLine($"结束刷新 全链路在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("全链路在途:" + ex.Message);
                        Console.WriteLine("全链路在途:" + ex.StackTrace);
                    }


                }
            });


            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始刷新 采购单理论交期，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       daily.ResetPurchaseQuantityNotInbound();
                       Console.WriteLine($"结束刷新 采购单理论交期，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("采购单理论交期:" + ex.Message);
                       Console.WriteLine("采购单理论交期:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       base_sku_dao.SynchroCharacter();
                       Console.WriteLine($"结束 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(60 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("拉取sku特性:" + ex.Message);
                       Console.WriteLine("拉取sku特性:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       base_sku_dao.SynchroSkuCharacter();
                       Console.WriteLine($"结束 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(10 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("拉取sku特性:" + ex.Message);
                       Console.WriteLine("拉取sku特性:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       base_sku_dao.SynchroSkuCharacterSupplement();
                       Console.WriteLine($"结束 拉取sku特性，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(24 * 60 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("拉取sku特性:" + ex.Message);
                       Console.WriteLine("拉取sku特性:" + ex.StackTrace);
                   }


               }
           });


            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 计算Shopify的备货数量，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       report.ClearShopifyJitInventory();
                       report.ShopifyJitInventory();
                       Console.WriteLine($"结束 计算Shopify的备货数量，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(60 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("计算Shopify的备货数量:" + ex.Message);
                       Console.WriteLine("计算Shopify的备货数量:" + ex.StackTrace);
                   }


               }
           });


            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 计算最近7天的订单数量，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       daily.ResetOrders7();
                       Console.WriteLine($"结束 计算最近7天的订单数量，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(4 * 60 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine("计算最近7天的订单数量:" + ex.Message);
                       Console.WriteLine("计算最近7天的订单数量:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 lm 产品换仓备货，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       lm_dao.ChangeWarehouseStockUp();
                       Console.WriteLine($"结束 lm 产品换仓备货，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" lm 产品换仓备货:" + ex.Message);
                       Console.WriteLine(" lm 产品换仓备货:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 推送lm的调拨计划，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       lm_dao.PustTransferPlan();
                       Console.WriteLine($"结束 推送lm的调拨计划，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" 推送lm的调拨计划:" + ex.Message);
                       Console.WriteLine(" 推送lm的调拨计划:" + ex.StackTrace);
                   }


               }
           });


            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 拉取pps sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       report_invest_return_dao.SynchPpsSku();
                       report_invest_return_dao.SynchYinjuSku();
                       Console.WriteLine($"结束 拉取pps sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(10 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" 拉取pps sku:" + ex.Message);
                       Console.WriteLine(" 拉取 pps sku:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始 拉取btm fee，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       report_invest_return_dao.SynchBtmAdFees();

                       report_invest_return_dao.SynchBtmOrderRefund();

                       Console.WriteLine($"结束 拉取 btm fee，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(10 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" 拉取 btm fee:" + ex.Message);
                       Console.WriteLine(" 拉取 btm fee:" + ex.StackTrace);
                   }


               }
           });

            Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始  分摊广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       report_invest_return_dao.ShareAdFee();
                       Console.WriteLine($"结束 分摊广告费，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(10 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" 分摊广告费:" + ex.Message);
                       Console.WriteLine(" 分摊广告费 :" + ex.StackTrace);
                   }


               }
           });

               Task.Factory.StartNew(() =>
           {
               while (true)
               {

                   try
                   {
                       Console.WriteLine($"开始  计算库存分，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       report_invest_return_dao.CalculationStockScore();
                       Console.WriteLine($"结束 计算库存分，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                       Thread.Sleep(10 * 60 * 1000);
                   }
                   catch (Exception ex)
                   {
                       Console.WriteLine(" 计算库存分:" + ex.Message);
                       Console.WriteLine(" 计算库存分 :" + ex.StackTrace);
                   }


               }
           });




            return Task.CompletedTask;
        }


        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
