﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace ResetOutofstock
{
    class DeviationRabbitBackgroundService : RabbitWorkerBase<t_task_queue>
    {

        public DeviationRabbitBackgroundService() : base("差异分析服务", "aims:deviation-v3:input", 1)
        {

        }

        protected override async Task DoWork(t_task_queue taskDto)
        {


            try
            {
                int hit = await dc_ana_deviation_dao.AnaDeviation(taskDto);
                Console.WriteLine($"差异分析服务 完成  {hit} ");
            }
            catch (Exception e)
            {
                RabbitMQHelper.EnqueneMsg("aims:deviation-v3:input", taskDto);
                Console.WriteLine($"差异分析服务 数据异常，异常原因为：{e.Message}，异常堆栈为：{e.StackTrace}");
            }

        }
    }
}
