﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ReportInvestReturnController : ControllerBase
    {


        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【ip+de投资回报分析】->【搜索】页面", 0)]
        public JsonResult AnaList(int limit, int offset, string order, string sort)
        {
            var total = 0;
            var service = new Services.ReportInvestReturnService();
            var list = service.AnaList(new Condition_ConfigPromotion { }, offset, limit, order, sort, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        public JsonResult AnaExport()
        {
            try
            {
                var user = AutoUtility.GetUser();
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = new { }.ToJson(),
                    task_name = "投资回报分析"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false, message = ex.Message });
            }
        }
        
    }
}