﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Utility;
using AutoTurnOver.Models.Report;
using System.Data;
using AutoTurnOver.Common;
using System.IO;
using AutoTurnOver.Models;
using AutoTurnOver.Models.stock;
using AutoTurnOver.DB;
using Dapper;
using AutoTurnOver.Models.auto;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DeviationController : ControllerBase
    {
        /// <summary>
        /// 差异分析 现金流 sku视图
        /// </summary>
        /// <param name="project"></param>
        /// <param name="sku"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="order"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public JsonResult GetSkuViews(string project, string sku, int offset, int limit, string order, string sort)
        {
            var m = new deviation_search_dto
            {
                project = project,
                sku = sku
            };
            var services = new DeviationServices();
            var total = 0;
            var list = services.GetSkuViews(m, offset, limit, ref total, order: order, sort: sort);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        public JsonResult Projects()
        {
            return new JsonResult(new DeviationServices().GetProjects().Select(s=>new { Name = s}));
        }
    }
}