﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.Report
{
    /// <summary>
    /// 供应链采购在途
    /// </summary>
    public class full_link_purchase_dto
    {
        public int sysId { get; set; }
        public DateTime create_time { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public string product_title { get; set; }
        public string buyer_name { get; set; }
        public string product_type_desc { get; set; }
        public decimal? stock { get; set; }
        public decimal? quantity_transfer { get; set; }
        public decimal? quantity_transfer_order { get; set; }
        public decimal? quantity_transfer_temp_schedule { get; set; }
        public decimal? quantity_transfer_temporary_storage { get; set; }
        public decimal? history_sevenday_sales { get; set; }
        public decimal? history_fourteenday_sales { get; set; }
        public decimal? history_thirtyday_sales { get; set; }
        public int? forecast_type { get; set; }
        public string forecast_type_str { get {
                if (forecast_type == null)
                {
                    return "";
                }
                else
                {
                    return ((forecast_type_enum)forecast_type).ToString();
                }
            } }

        public enum forecast_type_enum
        {
            实际缺货=1,预计缺货=2,实际冗余=3,预计冗余=4,断货=5
        }
        public string purchase_id { get; set; }
        public decimal quantity_purchase { get; set; }
        public decimal quantity_not_inbound { get; set; }
        public string purchase_status_str
        {
            get
            {
                return ((purchase_status_enum)purchase_status).ToString();
            }
        }
        public int purchase_status { get; set; }
        public enum purchase_status_enum
        {
            作废=-1,待确认=0,已确认=1,待入库 =3, 已完成=4
        }
        public DateTime? last_signtime { get; set; }
        public string last_signtime_str { get
            {
                if(last_signtime==null || last_signtime.Value.Year <= 2010)
                {
                    return "";
                }
                else
                {
                    return last_signtime.Value.ToString("yyyy-MM-dd");
                }
            } }
        public DateTime? purchase_arrivaldate { get; set; }
        public string purchase_arrivaldate_str
        {
            get
            {
                if (purchase_arrivaldate == null) return "";
                else {
                    return purchase_arrivaldate.Value.ToString("yyyy-MM-dd");
                }
            }
        }
        public decimal quantity_arrival { get; set; }
        public decimal quantity_inbound { get; set; }
        public string prod_status { get; set; }
        public decimal? prod_distribution_quantity { get; set; }
        public decimal? prod_not_distribution_quantity { get; set; }
        public decimal? prod_quantity { get; set; }
    }
}
