﻿using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using AutoTurnOver.Models.auto;
using AutoTurnOver.Models.Report;
using Dapper;

namespace AutoTurnOver.DB
{
    public class dc_ana_deviation_dao : connectionHelper
    {
        /// <summary>
        /// 分析差异数据
        /// </summary>
        /// <param name="taskDto"></param>
        /// <returns></returns>
        /// <exception cref="NotImplementedException"></exception>
        public static async Task<int> AnaDeviation(t_task_queue taskDto)
        {
            var now = DateTime.Now.GetMonthFirstDay().ToDayHome();
            var nowEdate = now.LastDayOfMonth().ToDayEnd();
            var nowDateStr = now.ToString("yyyy-MM");
            // 查询sku
            var skuDatas = taskDto.id.ToObj<List<dc_ana_deviation_sku>>();
            var skuData = skuDatas[0];

            var warehouse_codes = skuDatas.Select(s => s.warehouse_code).ToList();
            // 查询sku的供应链长度
            var turnover_datas = (await _connection.QueryAsync<Models.dc_auto_turnover>(" select * from dc_auto_turnover  where warehouse_code in @warehouse_codes and bailun_sku=@bailun_sku ", new
            {
                warehouse_codes = warehouse_codes,
                bailun_sku = skuData.sku
            })).ToList();

            // 查询库存表
            var stockDatas = (await _connection.QueryAsync<Models.dc_base_stock>(" select * from dc_base_stock  where warehouse_code in @warehouse_codes and bailun_sku=@bailun_sku ", new
            {
                warehouse_codes = warehouse_codes,
                bailun_sku = skuData.sku
            })).ToList();
            //查询在途数据
            var transitDatas = (await _connection.QueryAsync<Models.dc_mid_transit>(" select * from dc_mid_transit  where warehouse_code in @warehouse_codes and bailun_sku=@bailun_sku ", new
            {
                warehouse_codes = warehouse_codes,
                bailun_sku = skuData.sku
            })).ToList();
            var baseSkuData = _connection.QueryFirstOrDefault<dc_base_sku>(" select * from dc_base_sku where bailun_sku=@bailun_sku  ", new { bailun_sku = skuData.sku });
            var turnover_days = turnover_datas[0].turnover_days;
            var turnoverDaysEndDate = now.AddDays(turnover_days).LastDayOfMonth().ToDayEnd();
            // 查询配置的销量
            var month12 = DateTime.Parse(now.ToString("yyyy-12-31 23:59:59"));
            var salesDayConfigs = _connection.Query<dc_ana_deviation_sales_day_config>(" select * from dc_ana_deviation_sales_day_config where project=@project and bailun_sku=@bailun_sku and site in @sites and `edate`>=@bdate and `bdate`<=@edate  ", new
            {
                bailun_sku = baseSkuData.bailun_sku,
                sites = skuDatas.Select(s => s.site).ToList(),
                bdate = now,
                edate = month12,
                project = skuData.project
            }).ToList();

            var thisDate = now;
            List<dc_ana_deviation> datas = new List<dc_ana_deviation>();
            while (thisDate <= month12)
            {
                var thisBdate = thisDate.ToDayHome();
                var thisEdate = thisDate.LastDayOfMonth().ToDayEnd();
                var dateStr = thisDate.ToString("yyyy-MM");
                var sales = (salesDayConfigs.FirstOrDefault(s => s.date_str == dateStr) ?? new dc_ana_deviation_sales_day_config { }).sales;
                // 写入 【销售产品产品成本】、【销售产品数量】、【剩余可用库存金额】、【剩余可用库存数量】
                SaveDeviation(datas, new dc_ana_deviation { bdate = thisBdate, edate = thisEdate, date_str = dateStr, field_type = "预测值", field = "销售产品数量", project = skuData.project, sku = skuData.sku, val = sales });
                SaveDeviation(datas, new dc_ana_deviation { bdate = thisBdate, edate = thisEdate, date_str = dateStr, field_type = "预测值", field = "剩余可用库存数量", project = skuData.project, sku = skuData.sku, val = sales });
                SaveDeviation(datas, new dc_ana_deviation { bdate = thisBdate, edate = thisEdate, date_str = dateStr, field_type = "预测值", field = "销售产品成本", project = skuData.project, sku = skuData.sku, val = sales * baseSkuData.unit_price });
                SaveDeviation(datas, new dc_ana_deviation { bdate = thisBdate, edate = thisEdate, date_str = dateStr, field_type = "预测值", field = "剩余可用库存金额", project = skuData.project, sku = skuData.sku, val = sales * baseSkuData.unit_price });

                thisDate = thisDate.AddMonths(1);
            }




            // 读取实际值 【销售产品数量】、【销售产品产品成本】、【剩余可用库存数量】、【剩余可用库存金额】、【剩余调拨库存数量】、【剩余调拨库存金额】、【采购在途库存金额】、【采购在途库存数量】
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "剩余可用库存数量", project = skuData.project, sku = skuData.sku, val = stockDatas.Sum(s => s.usable_stock) });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "剩余可用库存金额", project = skuData.project, sku = skuData.sku, val = stockDatas.Sum(s => s.usable_stock) * baseSkuData.unit_price });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "采购在途库存数量", project = skuData.project, sku = skuData.sku, val = transitDatas.Sum(s => s.quantity_purchase) });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "采购在途库存金额", project = skuData.project, sku = skuData.sku, val = transitDatas.Sum(s => s.quantity_purchase) * baseSkuData.unit_price });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "剩余调拨库存数量", project = skuData.project, sku = skuData.sku, val = transitDatas.Sum(s => s.quantity_transfer) });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "剩余调拨库存金额", project = skuData.project, sku = skuData.sku, val = transitDatas.Sum(s => s.quantity_transfer) * baseSkuData.unit_price });

            // 查询销量
            var omsSale = await GetOmsSale(now, nowEdate, skuDatas);
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "销售产品数量", project = skuData.project, sku = skuData.sku, val = omsSale });
            SaveDeviation(datas, new dc_ana_deviation { bdate = now, edate = nowEdate, date_str = nowDateStr, field_type = "实际值", field = "销售产品成本", project = skuData.project, sku = skuData.sku, val = omsSale * baseSkuData.unit_price });


            var lastMonthB = now.AddMonths(-1).GetMonthFirstDay().ToDayHome();
            var lastMonthE = lastMonthB.LastDayOfMonth().ToDayEnd();
            var lastMonthDateStr = lastMonthB.ToString("yyyy-MM");

            //今日的推测值等于昨日的实际剩余
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "销售产品数量",
                project = skuData.project,
                sku = skuData.sku,
                val = _connection.QueryFirstOrDefault<decimal?>(" select `val`  from dc_ana_deviation where  sku=@sku  and project=@project and field=@field and date_str=@date_str and field_type=@field_type ", new
                {
                    sku = skuData.sku,
                    project = skuData.project,
                    field = "剩余可用库存数量",
                    date_str = lastMonthDateStr,
                    field_type = "实际值"
                }, commandTimeout: 0) ?? 0
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "销售产品成本",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "推测值" && s.date_str == nowDateStr).val * baseSkuData.unit_price
            });

            // 查询今日的预计到货数据
            var baseTransExpectarrivaltimeDatas = _connection.Query<dc_base_trans_expectarrivaltime_temp>(" select * from dc_base_trans_expectarrivaltime where bailun_sku=@bailun_sku and warehouse_code in @warehouse_codes and expectarrivaltime>=@btime and expectarrivaltime<=@etime ", new
            {
                warehouse_codes = warehouse_codes,
                bailun_sku = baseSkuData.bailun_sku,
                btime = now,
                etime = nowEdate
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "剩余可用库存数量",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "推测值" && s.date_str == nowDateStr).val + baseTransExpectarrivaltimeDatas.Sum(s => s.count) - datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "剩余可用库存金额",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "剩余可用库存数量" && s.field_type == "推测值" && s.date_str == nowDateStr).val * baseSkuData.unit_price
            });

            // 周转算法 实际可以用库存+周转期预测到货-周转期预测销量
            var turnoverDaysTransExpectarrivaltimeDatas = _connection.Query<dc_base_trans_expectarrivaltime_temp>(" select * from dc_base_trans_expectarrivaltime where bailun_sku=@bailun_sku and warehouse_code in @warehouse_codes  and expectarrivaltime<=@etime ", new
            {
                warehouse_codes = warehouse_codes,
                bailun_sku = baseSkuData.bailun_sku,
                etime = turnoverDaysEndDate
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "采购在途库存数量",
                project = skuData.project,
                sku = skuData.sku,
                val =
                 datas.FirstOrDefault(s => s.field == "剩余可用库存数量" && s.field_type == "实际值" && s.date_str == nowDateStr).val
                 + turnoverDaysTransExpectarrivaltimeDatas.Sum(s => s.count)
                 - salesDayConfigs.Where(s => s.bdate <= turnoverDaysEndDate).Sum(s => s.sales)
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "推测值",
                field = "采购在途库存金额",
                project = skuData.project,
                sku = skuData.sku,
                val =
               datas.FirstOrDefault(s => s.field == "采购在途库存数量" && s.field_type == "推测值" && s.date_str == nowDateStr).val * baseSkuData.unit_price
            });


            // 偏差分析 【产品成本预计偏差值】、【产品成本预计偏差比例】、【销售数量预计偏差值】、【销售数量预计偏差比例】、【产品成本实际偏差值】、【产品成本实际偏差比例】、【销售数量实际偏差值】、【销售数量实际偏差比例】
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "产品成本预计偏差值",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "推测值" && s.date_str == nowDateStr).val
                - datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "产品成本预计偏差比例",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "产品成本预计偏差值" && s.field_type == "偏差分析" && s.date_str == nowDateStr).val
                .Division(datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "预测值" && s.date_str == nowDateStr).val)
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "销售数量预计偏差值",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "推测值" && s.date_str == nowDateStr).val
                - datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "销售数量预计偏差比例",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售数量预计偏差值" && s.field_type == "偏差分析" && s.date_str == nowDateStr).val
               .Division(datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val)
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "产品成本实际偏差值",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "实际值" && s.date_str == nowDateStr).val
                - datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "产品成本实际偏差比例",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "产品成本实际偏差值" && s.field_type == "偏差分析" && s.date_str == nowDateStr).val
               .Division(datas.FirstOrDefault(s => s.field == "销售产品成本" && s.field_type == "预测值" && s.date_str == nowDateStr).val)
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "销售数量实际偏差值",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "实际值" && s.date_str == nowDateStr).val
                - datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "偏差分析",
                field = "销售数量实际偏差比例",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售数量实际偏差值" && s.field_type == "偏差分析" && s.date_str == nowDateStr).val
             .Division(datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val)
            });


            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "-",
                field = "超卖数量",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "实际值" && s.date_str == nowDateStr).val
                - datas.FirstOrDefault(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.date_str == nowDateStr).val
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "-",
                field = "呆滞数量",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "剩余可用库存数量" && s.field_type == "实际值" && s.date_str == nowDateStr).val
                - datas.Where(s => s.field == "销售产品数量" && s.field_type == "预测值" && s.bdate <= turnoverDaysEndDate && s.edate >= now).Sum(s => s.val) // 未来周转期的预测销量
            });
            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "-",
                field = "呆滞库存金额",
                project = skuData.project,
                sku = skuData.sku,
                val = datas.FirstOrDefault(s => s.field == "呆滞数量" && s.field_type == "-" && s.date_str == nowDateStr).val * baseSkuData.unit_price
            });

            SaveDeviation(datas, new dc_ana_deviation
            {
                bdate = now,
                edate = nowEdate,
                date_str = nowDateStr,
                field_type = "-",
                field = "是否断货",
                project = skuData.project,
                sku = skuData.sku,
                val = stockDatas.Sum(s => s.usable_stock)
            });

            return 1;

        }

        /// <summary>
        /// 查询sku汇总视图
        /// </summary>
        /// <param name="search_data"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <param name="order"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        /// <exception cref="NotImplementedException"></exception>
        public static IEnumerable<deviation_view_dto> GetSkuViews(deviation_search_dto search_data, int offset, int limit, ref int total, string order, string sort)
        {
            var datas = GetDatas(search_data);

            var viewDatas = new List<deviation_view_dto>() { };
            var year = DateTime.Now.Year;
            var allDatas = datas.GroupBy(s => new { s.sku, s.project, s.field, s.field_type }).OrderBy(s => s.Key.field_type);
            foreach (var item in allDatas.Take(limit).Skip(offset))
            {
                deviation_view_dto itemData = new deviation_view_dto()
                {
                    field = item.Key.field,
                    field_type = item.Key.field_type,
                    group_key = item.Key.sku,
                    project = item.Key.project,
                    month1 = GetVal(item.AsQueryable(), $"{year}-01"),
                    month2 = GetVal(item.AsQueryable(), $"{year}-02"),
                    month3 = GetVal(item.AsQueryable(), $"{year}-03"),
                    month4 = GetVal(item.AsQueryable(), $"{year}-04"),
                    month5 = GetVal(item.AsQueryable(), $"{year}-05"),
                    month6 = GetVal(item.AsQueryable(), $"{year}-06"),
                    month7 = GetVal(item.AsQueryable(), $"{year}-07"),
                    month8 = GetVal(item.AsQueryable(), $"{year}-08"),
                    month9 = GetVal(item.AsQueryable(), $"{year}-09"),
                    month10 = GetVal(item.AsQueryable(), $"{year}-10"),
                    month11 = GetVal(item.AsQueryable(), $"{year}-11"),
                    month12 = GetVal(item.AsQueryable(), $"{year}-12")
                };

                viewDatas.Add(itemData);
            }

            total = allDatas.Count();


            return viewDatas;
        }

        public static decimal? GetVal(IQueryable<dc_ana_deviation> list, string date_str)
        {
            var data = list.FirstOrDefault(s => date_str == s.date_str);
            if (data == null)
            {
                return null;
            }
            else
            {
                return data.val;
            }
        }


        public static List<dc_ana_deviation> GetDatas(deviation_search_dto search_data)
        {
            var yearBdate = DateTime.Parse(DateTime.Now.ToString("yyyy-01-01 00:00:00"));
            var yearEdate = DateTime.Parse(DateTime.Now.ToString("yyyy-12-31 23:59:59"));
            var sql = " select * from dc_ana_deviation as t1 where t1.bdate<=@yearEdate and t1.edate>=@yearBdate ";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("yearBdate", yearBdate);
            parameters.Add("yearEdate", yearEdate);
            if (!string.IsNullOrWhiteSpace(search_data.project))
            {
                sql += " and t1.project=@project ";
                parameters.Add("project", search_data.project);
            }
            if (!string.IsNullOrWhiteSpace(search_data.sku))
            {
                sql += " and t1.sku=@sku ";
                parameters.Add("sku", search_data.sku);
            }
            return _connection.Query<dc_ana_deviation>(sql, parameters, commandTimeout: 0).ToList();
        }

        public async static Task<decimal> GetOmsSale(DateTime btime, DateTime etime, List<dc_ana_deviation_sku> anaSkus)
        {
            var sql = " select * from dc_base_oms_sku where warehouse_code in @warehouse_codes and bailun_sku=@bailun_sku and   bailun_order_status not in ('Canceled')  and bailun_interception_status in ('None', 'Failed')  and paid_time<=@etime and paid_time>=@btime ";
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("warehouse_codes", anaSkus.Select(s => s.warehouse_code).ToList());
            parameters.Add("bailun_sku", anaSkus[0].sku);
            parameters.Add("btime", btime);
            parameters.Add("etime", etime);

            var omsDatas = (await _connection.QueryAsync<dc_base_oms_sku>(sql, parameters, commandTimeout: 0)).ToList();
            if (anaSkus.Any(s => !string.IsNullOrWhiteSpace(s.platform)))
            {
                var platforms = anaSkus.Where(s => !string.IsNullOrWhiteSpace(s.platform)).Select(s => s.platform).ToList();
                omsDatas = omsDatas.Where(s => platforms.Contains(s.platform_type)).ToList();
            }
            if (anaSkus.Any(s => s.account > 0))
            {
                var accounts = anaSkus.Where(s => s.account > 0).Select(s => s.account.Value.ToString()).ToList();
                omsDatas = omsDatas.Where(s => accounts.Contains(s.bailun_account_id)).ToList();
            }
            if (anaSkus.Any(s => !string.IsNullOrWhiteSpace(s.site)))
            {
                var sites = anaSkus.Where(s => !string.IsNullOrWhiteSpace(s.site)).ToList();
                omsDatas = omsDatas.Where(s => sites.Any(s1 =>
                (string.IsNullOrWhiteSpace(s1.platform) || s.platform_type.Equals(s1.platform))
                && (string.IsNullOrWhiteSpace(s1.site) || s.website.Equals(s1.site))
                )).ToList();
            }
            return omsDatas.Sum(s => s.bailun_sku_quantity_ordered);
        }

        public static void SaveDeviation(List<dc_ana_deviation> datas, dc_ana_deviation data)
        {
            if (data.field_type != "偏差分析")
            {
                data.val = Math.Max(data.val, 0);
            }
            data._ts = DateTime.Now;
            data.id = _connection.QueryFirstOrDefault<int?>(" select id from dc_ana_deviation where sku=@sku and  project=@project and field=@field and date_str=@date_str and field_type=@field_type ", new
            {
                sku = data.sku,
                project = data.project,
                field = data.field,
                date_str = data.date_str,
                field_type = data.field_type
            }) ?? 0;
            if (data.id <= 0)
            {
                _connection.Insert(data, commandTimeout: 0);
            }
            else
            {
                _connection.Update(data, commandTimeout: 0);
            }
            datas.Add(data);
        }

        /// <summary>
        /// 添加分析任务
        /// </summary>
        public static void PushAnaTask()
        {
            // 查询所有需要分析的sku
            var skuGroups = _connection.Query<dc_ana_deviation_sku>(" select * from dc_ana_deviation_sku  ").ToList().GroupBy(s => new { s.sku, s.project });
            foreach (var item in skuGroups)
            {
                RabbitMQHelper.EnqueneMsg("aims:deviation-v3:input", new t_task_queue { id = item.ToJson(), create_time = DateTime.Now });
            }
        }

        public static List<string> GetProjects()
        {
            return _connection.Query<string>("select DISTINCT project from dc_ana_deviation_sku").ToList();
        }
    }
}
