﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 产品刊登情况监控
    /// </summary>
    public class listing_status_view_dto
    {
        public string hq_type { get; set; }
        public string source_str
        {
            get
            {
                switch (source)
                {
                    case 1: return "精准开发";
                    case 2: return "线下（其他）";
                    case 3: return "线下美容";
                    case 6: return "普货供应商推荐";
                    case 7: return "服装产品中心";
                    case 11: return "无库供应商推荐";
                    default: return (source ?? 0).ToString();
                }
            }
        }
        public string area_name { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public string base_bailun_sku { get; set; }
        public string sku_title_cn { get; set; }
        public string product_code { get; set; }
        public string buyer_name { get; set; }
        public string brand { get; set; }
        public decimal? weight { get; set; }
        public decimal? unit_price { get; set; }
        public decimal? height { get; set; }
        public string has_tort { get; set; }
        public string monitor_status { get; set; }
        /// <summary>
        /// 7日日均
        /// </summary>
        public decimal? history_sevenday_sales { get; set; }
        public decimal usable_stock { get; set; }
        public decimal? usable_stock_amount { get; set; }
        public decimal? quantity_purchase { get; set; }
        public decimal? quantity_transfer { get; set; }
        public decimal? source { get; set; }
        public decimal? ebay_uk_china { get; set; }
        public decimal? ebay_uk_abroad { get; set; }
        public decimal? ebay_us_china { get; set; }
        public decimal? ebay_us_abroad { get; set; }
        public decimal? wish_us_china { get; set; }
        public decimal? wish_us_abroad { get; set; }
        public decimal? amazon_uk_china { get; set; }
        public decimal? amazon_uk_abroad { get; set; }
        public decimal? amazon_us_china { get; set; }
        public decimal? amazon_us_abroad { get; set; }
        public decimal? aliexpress_uk_china { get; set; }
        public decimal? aliexpress_uk_abroad { get; set; }
        public decimal? aliexpress_us_china { get; set; }
        public decimal? aliexpress_us_abroad { get; set; }
        public decimal? walmart_us_china { get; set; }
        public decimal? walmart_us_abroad { get; set; }
        public decimal? sears_us_china { get; set; }
        public decimal? sears_us_abroad { get; set; }

        public decimal? ebay_au_china { get; set; }
        public decimal? ebay_au_abroad { get; set; }
        public decimal? ebay_de_china { get; set; }
        public decimal? ebay_de_abroad { get; set; }
        public decimal? ebay_es_china { get; set; }
        public decimal? ebay_es_abroad { get; set; }
        public decimal? ebay_fr_china { get; set; }
        public decimal? ebay_fr_abroad { get; set; }
        public decimal? ebay_it_china { get; set; }
        public decimal? ebay_it_abroad { get; set; }
        public decimal? amazon_au_china { get; set; }
        public decimal? amazon_au_abroad { get; set; }
        public decimal? amazon_de_china { get; set; }
        public decimal? amazon_de_abroad { get; set; }
        public decimal? amazon_es_china { get; set; }
        public decimal? amazon_es_abroad { get; set; }
        public decimal? amazon_fr_china { get; set; }
        public decimal? amazon_fr_abroad { get; set; }
        public decimal? amazon_it_china { get; set; }
        public decimal? amazon_it_abroad { get; set; }
        public decimal? amazon_jp_china { get; set; }
        public decimal? amazon_jp_abroad { get; set; }
        public decimal? amazon_na_china { get; set; }
        public decimal? amazon_na_abroad { get; set; }
        public decimal? amazon_ca_china { get; set; }
        public decimal? amazon_ca_abroad { get; set; }
    }

    public class listing_status_view_search_dto: page_search_dto
    {
        public DateTime? end_date { get; set; }
        public DateTime? start_date { get; set; }
        public int? has_tort { get; set; }
        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }
        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
        public string platform { get; set; }

        /// <summary>
        /// 1 = 可上架
        /// 2 = 无在线
        /// </summary>
        public int? listing_status { get; set; }
        /// <summary>
        /// 商品来源
        /// </summary>
        public int? source { get; set; }
        
        /// <summary>
        /// 产品类型
        /// </summary>
        public int? product_type { get; set; }
        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; }
        public string product_code { get; set; }
    }
}
