﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Utility;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ReportsController : ControllerBase
    {
        /// <summary>ForecastSalePutinStockShort
        /// 获取预测销售+入库+库存+缺货数
        /// </summary>
        /// <param name="sku">sku编码</param>
        /// <param name="warehousecode">仓库编码</param>
        /// <returns></returns>
        public JsonResult ForecastSalePutinStockShort(string sku, string warehousecode)
        {
            var services = new Services.ReportServices();
            var result = services.ForecastSalePutinStockShort(sku, warehousecode);

            var count = 0;
            foreach (var item in result)
            {
                var arr = item.Split(',');

                if (arr.Length > 1)
                {
                    count = arr.Length;
                    break;
                }
            }
            //[0.13, 0.12, 0.11, 0.11, 0.1, 0.09, 0.09, 0.08, 0.08, 0.07, 0.06, 0.06, 0.05, 0.04, 0.04, 0.03, 0.02, 0.02, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
            var date = new List<string>();
            var today = DateTime.Now.AddDays(-7);

            for (var i = 0; i < count; i++)
            {
                date.Add(today.AddDays(i).ToString("MM/dd"));
            }

            var names = new List<string>() { "销量","计算规则", "预计入库", "可用库存", "预计缺货数量", "特殊销量", "市场因素", "建议下单数量", "人工下单数量" };
            var turnoverData = new Services.SkuAutoTurnServices().GetModel(sku, warehousecode);
            var saleVolumeData = new Services.SaleVolumeServices().GetBySkuWarehouseCode(sku, warehousecode);
            var averageTargets = PurchaseAverageTargetServices.GetList(sku);
            var averageTargetWarehouse = PurchaseAverageTargetServices.GetWarehouse(sku, warehousecode);
            DateTime turnoverDate = DateTime.Now.AddDays(turnoverData.turnover_days);

            // 计算到周转期前一天的累计销量
            decimal turnoverDatecumulativeSales = 0;
            var salesList = result[0].ToObj<List<decimal>>();
            for (int i = 7; i < turnoverData.turnover_days+7-1; i++)
            {
                turnoverDatecumulativeSales += salesList[i];
            }


            // 累计预计到货
            decimal turnoverDatepurchase = 0;
            var purchaseList = result[2].ToObj<List<decimal>>();
            for (int i = 7; i < turnoverData.turnover_days + 7; i++)
            {
                turnoverDatepurchase += purchaseList[i];
            }

            // 当日预测销量
             var turnoverDateSales =(int)result[0].ToObj<List<decimal>>()[turnoverData.turnover_days + 7-1];
            var buyFormula = new
            {
                turnoverDateStr = turnoverDate.ToString("yyyy-MM-dd"), // 取值日期
                turnoverDateSales = turnoverDateSales, // 当日预测销量
                turnoverDateStock = (int)result[3].ToObj<List<decimal>>()[turnoverData.turnover_days + 7-1],   // 当日预测库存,
                turnoverDatecumulativeSales = (int)turnoverDatecumulativeSales, // 累计销量
                nowStr = DateTime.Now.ToString("yyyy-MM-dd"), // 今天的日期
                nowShortage = (int)result[4].ToObj<List<decimal>>()[7], // 今天的实际缺货
                cumulativeShortageDate = turnoverDate.AddDays(-1).ToString("yyyy-MM-dd"),// 一直到周转期前一天的日期
                cumulativeShortage = (int)result[4].ToObj<List<decimal>>()[turnoverData.turnover_days + 7 - 1],  // 一直到周转期前一天的累计缺货
                average_overdue = Math.Max(0, turnoverData.average_overdue),
                nowDateStock = (int)result[3].ToObj<List<decimal>>()[7],   // 今天的预测库存
                turnoverDatepurchase = turnoverDatepurchase // 累计预计到货
            };
            return new JsonResult(new
            {
                data = result,
                turnoverData,
                saleVolumeData,
                days = date,
                names,
                averageTargets,
                averageTargetWarehouse,
                buyFormula
            }
            );
        }

    }
}