﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models.ApiDto
{
    /// <summary>
    /// 从aims拿到的调拨单数据
    /// </summary>
    public class api_lms_order_transfer_sku_dto
    {
        public int id { get; set; }

        /// <summary>
        /// 系统单号
        /// </summary>
        [Description("系统单号")]
        public string system_order_no { get; set; }

        /// <summary>
        /// 物流单号
        /// </summary>
        [Description("物流单号")]
        public string trackingno { get; set; }

        /// <summary>
        /// 目标送达时间
        /// </summary>
        [Description("目标送达时间")]
        public DateTime target_delivery_date { get; set; }

        /// <summary>
        /// 目的国家
        /// </summary>
        [Description("目的国家")]
        public string country { get; set; }

        /// <summary>
        /// 目的仓
        /// </summary>
        [Description("目的仓")]
        public string target_ware_name { get; set; }

        /// <summary>
        /// 目的仓
        /// </summary>
        [Description("目的仓")]
        public string target_ware_no { get; set; }

        /// <summary>
        /// 抓取时间
        /// </summary>
        [Description("抓取时间")]
        public DateTime gmt_create_date { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [Description("创建时间")]
        public DateTime create_date { get; set; }

        /// <summary>
        /// 邮编
        /// </summary>
        [Description("邮编")]
        public string postal_code { get; set; }

        /// <summary>
        /// 货物总价值
        /// </summary>
        [Description("货物总价值")]
        public decimal goods_cost { get; set; }

        /// <summary>
        /// 货物总重量
        /// </summary>
        [Description("货物总重量")]
        public decimal goods_weight { get; set; }

        /// <summary>
        /// 总费用
        /// </summary>
        [Description("总费用")]
        public decimal cost { get; set; }

        /// <summary>
        /// 基础运费
        /// </summary>
        [Description("基础运费")]
        public decimal freight_cost { get; set; }

        /// <summary>
        /// 文件费用
        /// </summary>
        [Description("文件费用")]
        public decimal file_cost { get; set; }

        /// <summary>
        /// 燃油费
        /// </summary>
        [Description("燃油费")]
        public decimal fuel_cost { get; set; }

        /// <summary>
        /// 清关费
        /// </summary>
        [Description("清关费")]
        public decimal clearance_cost { get; set; }

        /// <summary>
        /// 报关费
        /// </summary>
        [Description("报关费")]
        public decimal declare_cost { get; set; }

        /// <summary>
        /// vat 手续费
        /// </summary>
        [Description("vat 手续费")]
        public decimal vat_cost { get; set; }

        /// <summary>
        /// fda 手续费
        /// </summary>
        [Description("fda 手续费")]
        public decimal fda_cost { get; set; }

        /// <summary>
        /// 偏远费
        /// </summary>
        [Description("偏远费")]
        public decimal remote_cost { get; set; }

        /// <summary>
        /// 关税附加费
        /// </summary>
        [Description("关税附加费")]
        public decimal tariff_add_cost { get; set; }

        /// <summary>
        /// 揽收时间
        /// </summary>
        [Description("揽收时间")]
        public DateTime collect_time { get; set; }

        /// <summary>
        /// 上航时间
        /// </summary>
        [Description("揽收时间")]
        public DateTime flight_time { get; set; }

        /// <summary>
        /// 转运时间
        /// </summary>
        [Description("转运时间")]
        public DateTime transport_time { get; set; }

        /// <summary>
        /// 上网时间
        /// </summary>
        [Description("上网时间")]
        public DateTime ascan_time { get; set; }

        /// <summary>
        /// 到港时间
        /// </summary>
        [Description("到港时间")]
        public DateTime arrival_time { get; set; }

        /// <summary>
        /// 清关时间
        /// </summary>
        [Description("清关时间")]
        public DateTime clearance_time { get; set; }

        /// <summary>
        /// 签收时间
        /// </summary>
        [Description("签收时间")]
        public DateTime sign_time { get; set; }

        /// <summary>
        /// 入库时间
        /// </summary>
        [Description("入库时间")]
        public DateTime put_time { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        [Description("sku")]
        public string sku { get; set; }

        /// <summary>
        /// sku 名称
        /// </summary>
        [Description("sku 名称")]
        public string sku_title { get; set; }

        /// <summary>
        ///数量
        /// </summary>
        [Description("数量")]
        public int quantity { get; set; }

        /// <summary>
        /// 是否删除
        /// </summary>
        [Description("是否删除")]
        public int? is_delete { get; set; }

        /// <summary>
        /// 发货时间
        /// </summary>
        [Description("发货时间")]
        public DateTime shipping_time { get; set; }

        /// <summary>
        /// 运输方式
        /// </summary>
        [Description("运输方式")]
        public int transport_type_val { get; set; }

        /// <summary>
        /// 运输方式
        /// </summary>
        [Description("运输方式")]
        public string transport_type { get; set; }

        /// <summary>
        /// 物流编码
        /// </summary>
        [Description("物流编码")]
        public string logistics_code { get; set; }

        /// <summary>
        /// 物流名称
        /// </summary>
        [Description("物流名称")]
        public string logistics_name { get; set; }
    }

    public class api_avg_days_dto
    {
        public string logistics_code { get; set; }
        public decimal avg_sign_days { get; set; }
        public decimal? avg_put_days { get; set; }
        public string logistics_name { get; set; }
        public string transport_type { get; set; }
    }

    public class api_avg_order_transfer_dto
    {
        public string order_no { get; set; }
        public string logistics_code { get; set; }
        public string logistics_name { get; set; }
        public string transport_type { get; set; }
        //public decimal sign_days { get; set; }
        //public decimal put_days { get; set; }
        //public decimal sail_days { get; set; }
        public DateTime shipping_time { get; set; }
        public DateTime sail_time { get; set; }
        public DateTime sign_time { get; set; }
        public DateTime put_time { get; set; }
        public DateTime bale_time { get; set; }
        public DateTime create_date { get; set; }
        public decimal calculation_sign_days { get {
                return (decimal)(sign_time - sail_time).TotalHours / 24;
            } }
        public decimal calculation_put_days
        { get {
                return (decimal)(put_time - sign_time).TotalHours / 24;
            } }
        public decimal calculation_bale_days
        { get {
                return (decimal)(bale_time - create_date).TotalHours / 24;
            } }
        public decimal calculation_order_days
        { get {
                return (decimal)(shipping_time - bale_time).TotalHours / 24;
            } }
        public decimal calculation_sail_days
        { get {
                return (decimal)(sail_time - shipping_time).TotalHours / 24;
            } }
    }

    public class api_lms_order_transfer_sku_requst_dto
    {
        public string bailun_sku { get; set; }
        public string country { get; set; }
        public string warehouse_code { get; set; }

        public int orders { get; set; }

        public string transfer_type { get; set; }
        public int? transfer_type_val { get; set; }
        public string logistics_code { get; set; }
    }

}
