﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace AutoTurnOver.Purchase.AverageTarget
{
    public class AverageTargetBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));

            Task.Factory.StartNew(() =>
            {
                try
                {
                    Console.WriteLine($"开始  init ，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAverageTargetServices.CalculationTransfer();
                    Console.WriteLine($"结束 init，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("周销售系数计算异常" + ex.Message);
                    Console.WriteLine("周销售系数计算异常" + ex.StackTrace);
                }
            });

            Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        //Console.WriteLine($"开始 计算预测现金流，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        report_cash_flow_forecast_dao.Calculation();
                        //Console.WriteLine($"结束 计算预测现金流，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("计算预测现金流" + ex.Message);
                    }


                    Thread.Sleep(10 * 1000);
                }
            });

            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;
                // 计算周转前半小时，计算fba调拨在途
                if (now.Hour == 23 && now.Minute == 29)
                {
                    Console.WriteLine($"开始 fba调拨在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetTransExpectArrivaltime();
                    Console.WriteLine($"开始 fba调拨在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 13 && now.Minute == 30)
                {
                    Console.WriteLine($"开始 fba调拨在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetTransExpectArrivaltime();
                    Console.WriteLine($"开始 fba调拨在途，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }

                if (now.Hour == 23 && now.Minute == 01)
                {
                    Console.WriteLine($"开始 设置默认头程方式，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetHeadType();
                    Console.WriteLine($"结束 设置默认头程方式，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }

                if (now.Hour == 23 && now.Minute == 02)
                {
                    Console.WriteLine($"开始 计算最快入库天数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    report.ResetFastestStorage();
                    Console.WriteLine($"结束 计算最快入库天数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                // 判断是不是指定的时间
                if (now.Hour == 23 && now.Minute == 58)
                {
                    Console.WriteLine($"开始 计算周销售系数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    dc_base_week_coefficient_dao.ResetData();
                    Console.WriteLine($"结束 计算周销售系数，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
               // 判断是不是指定的时间
                if (now.Hour == 23 && now.Minute == 58)
                {
                    Console.WriteLine($"开始同步sku刊登状态，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    daily.SynchroPPSSkuStatus();
                    Console.WriteLine($"结束同步sku刊登状态，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 23 && now.Minute == 59)
                {
                    Console.WriteLine($"开始采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAverageTargetServices.Calculation();
                    Console.WriteLine($"结束采购平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                if (now.Hour == 23 && now.Minute == 57)
                {
                    Console.WriteLine($"开始调拨平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    PurchaseAverageTargetServices.CalculationTransfer();
                    Console.WriteLine($"结束调拨平均值统计任务，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                // 判断是不是指定的时间
                if (now.Hour == 00 && now.Minute == 20)
                {
                    Console.WriteLine($"开始 计算退款sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    dc_auto_return_goods_config_dao.Calculation();
                    Console.WriteLine($"结束 计算退款sku，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                // 判断是不是指定的时间
                if (now.Hour == 00 && now.Minute == 21)
                {
                    Console.WriteLine($"开始 计算退款数据汇总，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    dc_auto_return_goods_config_dao.NewCalculation();
                    Console.WriteLine($"结束 计算退款数据汇总，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
